/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.narpc;

import com.ibm.narpc.NaRPCGroup;
import com.ibm.narpc.NaRPCMessage;
import com.ibm.narpc.NaRPCServerChannel;
import com.ibm.narpc.NaRPCService;
import com.ibm.narpc.NaRPCUtils;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaRPCDispatcher<R extends NaRPCMessage, T extends NaRPCMessage>
implements Runnable {
    private static Logger LOG = NaRPCUtils.getLogger();
    private NaRPCGroup group;
    private LinkedBlockingQueue<NaRPCServerChannel> incomingChannels;
    private NaRPCService<R, T> service;
    private Selector selector;
    private R request;
    private int id;
    private boolean isAlive;

    public NaRPCDispatcher() {
        this.isAlive = true;
    }

    public NaRPCDispatcher(NaRPCGroup group, NaRPCService<R, T> service, int id) throws IOException {
        this.group = group;
        this.service = service;
        this.id = id;
        this.selector = Selector.open();
        this.incomingChannels = new LinkedBlockingQueue();
        this.request = service.createRequest();
        this.isAlive = true;
    }

    public void addChannel(NaRPCServerChannel endpoint) throws IOException {
        this.service.addEndpoint(endpoint);
        this.incomingChannels.add(endpoint);
        this.selector.wakeup();
    }

    public void close() {
        this.isAlive = false;
    }

    @Override
    public void run() {
        try {
            while (this.isAlive) {
                int readyChannels = this.selector.select(1000L);
                if (readyChannels > 0) {
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
                    while (keyIterator.hasNext()) {
                        SelectionKey key = keyIterator.next();
                        if (!key.isValid()) continue;
                        if (key.isReadable()) {
                            NaRPCServerChannel channel = (NaRPCServerChannel)key.attachment();
                            long ticket = channel.receiveMessage((NaRPCMessage)this.request);
                            if (ticket > 0L) {
                                T response = this.service.processRequest(this.request);
                                channel.transmitMessage(ticket, (NaRPCMessage)response);
                            } else if (ticket < 0L) {
                                LOG.info("closing channel " + channel.address());
                                this.service.removeEndpoint(channel);
                                key.cancel();
                                channel.close();
                            } else {
                                throw new Exception("ticket number invalid");
                            }
                        }
                        keyIterator.remove();
                    }
                }
                this.processIncomingChannels();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOG.info("closing the select call");
    }

    public void processIncomingChannels() throws IOException {
        NaRPCServerChannel channel = this.incomingChannels.poll();
        while (channel != null) {
            SocketChannel socket = channel.getSocketChannel();
            socket.configureBlocking(false);
            socket.socket().setTcpNoDelay(this.group.isNodelay());
            socket.socket().setReuseAddress(true);
            socket.register(this.selector, 1, channel);
            LOG.info("adding new channel to selector, from " + socket.getRemoteAddress());
            channel = this.incomingChannels.poll();
        }
    }
}

