/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.namenode.DataNodeBlocks;
import org.apache.crail.namenode.NameNodeBlockInfo;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.utils.AtomicIntegerModulo;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

class StorageClass {
    private static final Logger LOG = CrailUtils.getLogger();
    private int storageClass;
    private ConcurrentHashMap<Long, DataNodeBlocks> membership;
    private ConcurrentHashMap<Integer, DataNodeArray> affinitySets;
    private DataNodeArray anySet;
    private BlockSelection blockSelection;

    public StorageClass(int storageClass) {
        this.storageClass = storageClass;
        this.membership = new ConcurrentHashMap();
        this.affinitySets = new ConcurrentHashMap();
        this.blockSelection = CrailConstants.NAMENODE_BLOCKSELECTION.equalsIgnoreCase("roundrobin") ? new RoundRobinBlockSelection() : new RandomBlockSelection();
        this.anySet = new DataNodeArray(this.blockSelection);
    }

    public short updateRegion(BlockInfo region) {
        long dnAddress = region.getDnInfo().key();
        DataNodeBlocks current = this.membership.get(dnAddress);
        if (current == null) {
            return RpcErrors.ERR_ADD_BLOCK_FAILED;
        }
        return current.updateRegion(region);
    }

    public boolean regionExists(BlockInfo region) {
        long dnAddress = region.getDnInfo().key();
        DataNodeBlocks current = this.membership.get(dnAddress);
        if (current == null) {
            return false;
        }
        return current.regionExists(region);
    }

    short addBlock(NameNodeBlockInfo block) throws UnknownHostException {
        long dnAddress = block.getDnInfo().key();
        DataNodeBlocks current = this.membership.get(dnAddress);
        if (current == null) {
            current = DataNodeBlocks.fromDataNodeInfo(block.getDnInfo());
            this.addDataNode(current);
        }
        current.touch();
        current.addFreeBlock(block);
        return RpcErrors.ERR_OK;
    }

    NameNodeBlockInfo getBlock(int affinity) throws InterruptedException {
        NameNodeBlockInfo block = null;
        if (affinity == 0) {
            block = this.anySet.get();
        } else {
            block = this._getAffinityBlock(affinity);
            if (block == null) {
                block = this.anySet.get();
            }
        }
        return block;
    }

    DataNodeBlocks getDataNode(DataNodeInfo dataNode) {
        return this.membership.get(dataNode.key());
    }

    short addDataNode(DataNodeBlocks dataNode) {
        DataNodeBlocks current = this.membership.putIfAbsent(dataNode.key(), dataNode);
        if (current != null) {
            return RpcErrors.ERR_DATANODE_NOT_REGISTERED;
        }
        this._addDataNode(dataNode);
        return RpcErrors.ERR_OK;
    }

    private void _addDataNode(DataNodeBlocks dataNode) {
        LOG.info("adding datanode " + CrailUtils.getIPAddressFromBytes((byte[])dataNode.getIpAddress()) + ":" + dataNode.getPort() + " of type " + dataNode.getStorageType() + " to storage class " + this.storageClass);
        DataNodeArray hostMap = this.affinitySets.get(dataNode.getLocationClass());
        if (hostMap == null) {
            hostMap = new DataNodeArray(this.blockSelection);
            DataNodeArray oldMap = this.affinitySets.putIfAbsent(dataNode.getLocationClass(), hostMap);
            if (oldMap != null) {
                hostMap = oldMap;
            }
        }
        hostMap.add(dataNode);
        this.anySet.add(dataNode);
    }

    private NameNodeBlockInfo _getAffinityBlock(int affinity) throws InterruptedException {
        NameNodeBlockInfo block = null;
        DataNodeArray affinitySet = this.affinitySets.get(affinity);
        if (affinitySet != null) {
            block = affinitySet.get();
        }
        return block;
    }

    private class DataNodeArray {
        private ArrayList<DataNodeBlocks> arrayList = new ArrayList();
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        private BlockSelection blockSelection;

        public DataNodeArray(BlockSelection blockSelection) {
            this.blockSelection = blockSelection;
        }

        public void add(DataNodeBlocks dataNode) {
            this.lock.writeLock().lock();
            try {
                this.arrayList.add(dataNode);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NameNodeBlockInfo get() throws InterruptedException {
            this.lock.readLock().lock();
            try {
                NameNodeBlockInfo block = null;
                int size = this.arrayList.size();
                if (size > 0) {
                    int startIndex = this.blockSelection.getNext(size);
                    for (int i = 0; i < size; ++i) {
                        int index = (startIndex + i) % size;
                        DataNodeBlocks anyDn = this.arrayList.get(index);
                        if (anyDn.isOnline()) {
                            block = anyDn.getFreeBlock();
                        }
                        if (block != null) break;
                    }
                }
                NameNodeBlockInfo nameNodeBlockInfo = block;
                return nameNodeBlockInfo;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    private class RandomBlockSelection
    implements BlockSelection {
        public RandomBlockSelection() {
            LOG.info("random block selection");
        }

        @Override
        public int getNext(int size) {
            return ThreadLocalRandom.current().nextInt(size);
        }
    }

    private class RoundRobinBlockSelection
    implements BlockSelection {
        private AtomicIntegerModulo counter;

        public RoundRobinBlockSelection() {
            LOG.info("round robin block selection");
            this.counter = new AtomicIntegerModulo();
        }

        @Override
        public int getNext(int size) {
            return this.counter.getAndIncrement() % size;
        }
    }

    public static interface BlockSelection {
        public int getNext(int var1);
    }
}

