/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.io.IOException;
import java.net.URI;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.metadata.FileName;
import org.apache.crail.namenode.AbstractNode;
import org.apache.crail.namenode.BlockStore;
import org.apache.crail.namenode.DataNodeBlocks;
import org.apache.crail.namenode.FileStore;
import org.apache.crail.namenode.GCServer;
import org.apache.crail.namenode.NameNodeBlockInfo;
import org.apache.crail.namenode.Sequencer;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.rpc.RpcProtocol;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.rpc.RpcResponseMessage;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class NameNodeService
implements RpcNameNodeService,
Sequencer {
    private static final Logger LOG = CrailUtils.getLogger();
    private long serviceId;
    private long serviceSize;
    private AtomicLong sequenceId;
    private BlockStore blockStore;
    private DelayQueue<AbstractNode> deleteQueue;
    private FileStore fileTree;
    private ConcurrentHashMap<Long, AbstractNode> fileTable;
    private GCServer gcServer;

    public NameNodeService() throws IOException {
        URI uri = URI.create(CrailConstants.NAMENODE_ADDRESS);
        String query = uri.getRawQuery();
        StringTokenizer tokenizer = new StringTokenizer(query, "&");
        this.serviceId = Long.parseLong(tokenizer.nextToken().substring(3));
        this.serviceSize = Long.parseLong(tokenizer.nextToken().substring(5));
        this.sequenceId = new AtomicLong(this.serviceId);
        this.blockStore = new BlockStore();
        this.deleteQueue = new DelayQueue();
        this.fileTree = new FileStore(this);
        this.fileTable = new ConcurrentHashMap();
        this.gcServer = new GCServer(this, this.deleteQueue);
        AbstractNode root = this.fileTree.getRoot();
        this.fileTable.put(root.getFd(), root);
        Thread gc = new Thread(this.gcServer);
        gc.start();
    }

    @Override
    public long getNextId() {
        return this.sequenceId.getAndAdd(this.serviceSize);
    }

    public short createFile(RpcRequestMessage.CreateFileReq request, RpcResponseMessage.CreateFileRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)1, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileName fileHash = request.getFileName();
        CrailNodeType type = request.getFileType();
        boolean writeable = !type.isDirectory();
        int storageClass = request.getStorageClass();
        int locationClass = request.getLocationClass();
        boolean enumerable = request.isEnumerable();
        if (type.isContainer() && locationClass > 0) {
            return RpcErrors.ERR_DIR_LOCATION_AFFINITY_MISMATCH;
        }
        AbstractNode parentInfo = this.fileTree.retrieveParent(fileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (parentInfo == null) {
            return RpcErrors.ERR_PARENT_MISSING;
        }
        if (!parentInfo.getType().isContainer()) {
            return RpcErrors.ERR_PARENT_NOT_DIR;
        }
        if (storageClass < 0) {
            storageClass = parentInfo.getStorageClass();
        }
        if (locationClass < 0) {
            locationClass = parentInfo.getLocationClass();
        }
        AbstractNode fileInfo = this.fileTree.createNode(fileHash.getFileComponent(), type, storageClass, locationClass, enumerable);
        try {
            AbstractNode oldNode = parentInfo.putChild(fileInfo);
            if (oldNode != null && oldNode.getFd() != fileInfo.getFd()) {
                this.appendToDeleteQueue(oldNode);
            }
        }
        catch (Exception e) {
            return RpcErrors.ERR_FILE_EXISTS;
        }
        this.fileTable.put(fileInfo.getFd(), fileInfo);
        NameNodeBlockInfo fileBlock = this.blockStore.getBlock(fileInfo.getStorageClass(), fileInfo.getLocationClass());
        if (fileBlock == null) {
            return RpcErrors.ERR_NO_FREE_BLOCKS;
        }
        if (!fileInfo.addBlock(0, fileBlock)) {
            return RpcErrors.ERR_ADD_BLOCK_FAILED;
        }
        NameNodeBlockInfo parentBlock = null;
        if (fileInfo.getDirOffset() >= 0L) {
            int index = CrailUtils.computeIndex((long)fileInfo.getDirOffset());
            parentBlock = parentInfo.getBlock(index);
            if (parentBlock == null) {
                parentBlock = this.blockStore.getBlock(parentInfo.getStorageClass(), parentInfo.getLocationClass());
                if (parentBlock == null) {
                    return RpcErrors.ERR_NO_FREE_BLOCKS;
                }
                if (!parentInfo.addBlock(index, parentBlock)) {
                    this.blockStore.addBlock(parentBlock);
                    parentBlock = parentInfo.getBlock(index);
                    if (parentBlock == null) {
                        this.blockStore.addBlock(fileBlock);
                        return RpcErrors.ERR_CREATE_FILE_FAILED;
                    }
                }
            }
            parentInfo.incCapacity(CrailConstants.DIRECTORY_RECORD);
        }
        if (writeable) {
            fileInfo.updateToken();
            response.shipToken(true);
        } else {
            response.shipToken(false);
        }
        response.setParentInfo((FileInfo)parentInfo);
        response.setFileInfo((FileInfo)fileInfo);
        response.setFileBlock((BlockInfo)fileBlock);
        response.setDirBlock((BlockInfo)parentBlock);
        if (CrailConstants.DEBUG) {
            LOG.info("createFile: fd " + fileInfo.getFd() + ", parent " + parentInfo.getFd() + ", writeable " + writeable + ", token " + fileInfo.getToken() + ", capacity " + fileInfo.getCapacity() + ", dirOffset " + fileInfo.getDirOffset());
        }
        return RpcErrors.ERR_OK;
    }

    public short getFile(RpcRequestMessage.GetFileReq request, RpcResponseMessage.GetFileRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)2, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileName fileHash = request.getFileName();
        boolean writeable = request.isWriteable();
        AbstractNode fileInfo = this.fileTree.retrieveFile(fileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (fileInfo == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        if (writeable && !fileInfo.tokenFree()) {
            return RpcErrors.ERR_TOKEN_TAKEN;
        }
        if (writeable) {
            fileInfo.updateToken();
        }
        this.fileTable.put(fileInfo.getFd(), fileInfo);
        NameNodeBlockInfo fileBlock = fileInfo.getBlock(0);
        response.setFileInfo((FileInfo)fileInfo);
        response.setFileBlock((BlockInfo)fileBlock);
        if (writeable) {
            response.shipToken();
        }
        if (CrailConstants.DEBUG) {
            LOG.info("getFile: fd " + fileInfo.getFd() + ", isDir " + fileInfo.getType().isDirectory() + ", token " + fileInfo.getToken() + ", capacity " + fileInfo.getCapacity());
        }
        return RpcErrors.ERR_OK;
    }

    public short setFile(RpcRequestMessage.SetFileReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)3, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileInfo fileInfo = request.getFileInfo();
        boolean close = request.isClose();
        AbstractNode storedFile = this.fileTable.get(fileInfo.getFd());
        if (storedFile == null) {
            return RpcErrors.ERR_FILE_NOT_OPEN;
        }
        if (storedFile.getToken() > 0L && storedFile.getToken() == fileInfo.getToken()) {
            storedFile.setCapacity(fileInfo.getCapacity());
        }
        if (close) {
            storedFile.resetToken();
        }
        if (CrailConstants.DEBUG) {
            LOG.info("setFile: " + fileInfo.toString() + ", close " + close);
        }
        return RpcErrors.ERR_OK;
    }

    public short removeFile(RpcRequestMessage.RemoveFileReq request, RpcResponseMessage.DeleteFileRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)4, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileName fileHash = request.getFileName();
        AbstractNode parentInfo = this.fileTree.retrieveParent(fileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (parentInfo == null) {
            return RpcErrors.ERR_CREATE_FILE_FAILED;
        }
        AbstractNode fileInfo = this.fileTree.retrieveFile(fileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (fileInfo == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        response.setParentInfo((FileInfo)parentInfo);
        response.setFileInfo((FileInfo)fileInfo);
        fileInfo = parentInfo.removeChild(fileInfo.getComponent());
        if (fileInfo == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        this.appendToDeleteQueue(fileInfo);
        if (CrailConstants.DEBUG) {
            LOG.info("removeFile: filename, fd " + fileInfo.getFd());
        }
        return RpcErrors.ERR_OK;
    }

    public short renameFile(RpcRequestMessage.RenameFileReq request, RpcResponseMessage.RenameRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)5, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileName srcFileHash = request.getSrcFileName();
        FileName dstFileHash = request.getDstFileName();
        AbstractNode srcParent = this.fileTree.retrieveParent(srcFileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (srcParent == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        AbstractNode srcFile = this.fileTree.retrieveFile(srcFileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (srcFile == null) {
            return RpcErrors.ERR_SRC_FILE_NOT_FOUND;
        }
        int index = CrailUtils.computeIndex((long)srcFile.getDirOffset());
        NameNodeBlockInfo srcBlock = srcParent.getBlock(index);
        if (srcBlock == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        response.setSrcParent((FileInfo)srcParent);
        response.setSrcFile((FileInfo)srcFile);
        response.setSrcBlock((BlockInfo)srcBlock);
        AbstractNode dstParent = this.fileTree.retrieveParent(dstFileHash, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (dstParent == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        AbstractNode dstFile = this.fileTree.retrieveFile(dstFileHash, errorState);
        if (dstFile != null && !dstFile.getType().isDirectory()) {
            return RpcErrors.ERR_FILE_EXISTS;
        }
        if (dstFile != null && dstFile.getType().isDirectory()) {
            dstParent = dstFile;
        }
        if ((srcFile = srcParent.removeChild(srcFile.getComponent())) == null) {
            return RpcErrors.ERR_SRC_FILE_NOT_FOUND;
        }
        srcFile.rename(dstFileHash.getFileComponent());
        try {
            AbstractNode oldNode = dstParent.putChild(srcFile);
            if (oldNode != null && oldNode.getFd() != srcFile.getFd()) {
                this.appendToDeleteQueue(oldNode);
            }
            dstFile = srcFile;
        }
        catch (Exception e) {
            return RpcErrors.ERR_FILE_EXISTS;
        }
        index = CrailUtils.computeIndex((long)srcFile.getDirOffset());
        NameNodeBlockInfo dstBlock = dstParent.getBlock(index);
        if (dstBlock == null) {
            dstBlock = this.blockStore.getBlock(dstParent.getStorageClass(), dstParent.getLocationClass());
            if (dstBlock == null) {
                return RpcErrors.ERR_NO_FREE_BLOCKS;
            }
            if (!dstParent.addBlock(index, dstBlock)) {
                this.blockStore.addBlock(dstBlock);
                dstBlock = dstParent.getBlock(index);
                if (dstBlock == null) {
                    this.blockStore.addBlock(srcBlock);
                    return RpcErrors.ERR_CREATE_FILE_FAILED;
                }
            }
        }
        dstParent.incCapacity(CrailConstants.DIRECTORY_RECORD);
        response.setDstParent((FileInfo)dstParent);
        response.setDstFile((FileInfo)dstFile);
        response.setDstBlock((BlockInfo)dstBlock);
        if (response.getDstParent().getCapacity() < response.getDstFile().getDirOffset() + (long)CrailConstants.DIRECTORY_RECORD) {
            LOG.info("rename: parent capacity does not match dst file offset, capacity " + response.getDstParent().getCapacity() + ", offset " + response.getDstFile().getDirOffset() + ", capacity " + dstParent.getCapacity() + ", offset " + dstFile.getDirOffset());
        }
        if (CrailConstants.DEBUG) {
            LOG.info("renameFile: src-parent " + srcParent.getFd() + ", src-file " + srcFile.getFd() + ", dst-parent " + dstParent.getFd() + ", dst-fd " + dstFile.getFd());
        }
        return RpcErrors.ERR_OK;
    }

    public short getDataNode(RpcRequestMessage.GetDataNodeReq request, RpcResponseMessage.GetDataNodeRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)12, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        DataNodeInfo dnInfo = request.getInfo();
        DataNodeBlocks dnInfoNn = this.blockStore.getDataNode(dnInfo);
        if (dnInfoNn == null) {
            return RpcErrors.ERR_DATANODE_NOT_REGISTERED;
        }
        dnInfoNn.touch();
        response.setServiceId(this.serviceId);
        response.setFreeBlockCount(dnInfoNn.getBlockCount());
        return RpcErrors.ERR_OK;
    }

    public short setBlock(RpcRequestMessage.SetBlockReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)8, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        BlockInfo region = new BlockInfo();
        region.setBlockInfo(request.getBlockInfo());
        short error = RpcErrors.ERR_OK;
        if (this.blockStore.regionExists(region)) {
            error = this.blockStore.updateRegion(region);
        } else {
            int realBlocks = (int)((long)region.getLength() / CrailConstants.BLOCK_SIZE);
            long offset = 0L;
            for (int i = 0; i < realBlocks; ++i) {
                NameNodeBlockInfo nnBlock = new NameNodeBlockInfo(region, offset, (int)CrailConstants.BLOCK_SIZE);
                error = this.blockStore.addBlock(nnBlock);
                offset += CrailConstants.BLOCK_SIZE;
                if (error != RpcErrors.ERR_OK) break;
            }
        }
        return error;
    }

    public short getBlock(RpcRequestMessage.GetBlockReq request, RpcResponseMessage.GetBlockRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)6, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        long fd = request.getFd();
        long token = request.getToken();
        long position = request.getPosition();
        long capacity = request.getCapacity();
        if (position < 0L) {
            return RpcErrors.ERR_POSITION_NEGATIV;
        }
        AbstractNode fileInfo = this.fileTable.get(fd);
        if (fileInfo == null) {
            return RpcErrors.ERR_FILE_NOT_OPEN;
        }
        int index = CrailUtils.computeIndex((long)position);
        if (index < 0) {
            return RpcErrors.ERR_POSITION_NEGATIV;
        }
        NameNodeBlockInfo block = fileInfo.getBlock(index);
        if (block == null && fileInfo.getToken() == token) {
            block = this.blockStore.getBlock(fileInfo.getStorageClass(), fileInfo.getLocationClass());
            if (block == null) {
                return RpcErrors.ERR_NO_FREE_BLOCKS;
            }
            if (!fileInfo.addBlock(index, block)) {
                return RpcErrors.ERR_ADD_BLOCK_FAILED;
            }
            block = fileInfo.getBlock(index);
            if (block == null) {
                return RpcErrors.ERR_ADD_BLOCK_FAILED;
            }
            fileInfo.setCapacity(capacity);
        } else {
            if (block == null && token > 0L) {
                return RpcErrors.ERR_TOKEN_MISMATCH;
            }
            if (block == null && token == 0L) {
                return RpcErrors.ERR_CAPACITY_EXCEEDED;
            }
        }
        response.setBlockInfo((BlockInfo)block);
        return RpcErrors.ERR_OK;
    }

    public short getLocation(RpcRequestMessage.GetLocationReq request, RpcResponseMessage.GetLocationRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)7, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        FileName fileName = request.getFileName();
        long position = request.getPosition();
        if (position < 0L) {
            return RpcErrors.ERR_POSITION_NEGATIV;
        }
        AbstractNode fileInfo = this.fileTree.retrieveFile(fileName, errorState);
        if (errorState.getError() != RpcErrors.ERR_OK) {
            return errorState.getError();
        }
        if (fileInfo == null) {
            return RpcErrors.ERR_GET_FILE_FAILED;
        }
        int index = CrailUtils.computeIndex((long)position);
        if (index < 0) {
            return RpcErrors.ERR_POSITION_NEGATIV;
        }
        NameNodeBlockInfo block = fileInfo.getBlock(index);
        if (block == null) {
            return RpcErrors.ERR_OFFSET_TOO_LARGE;
        }
        response.setBlockInfo((BlockInfo)block);
        return RpcErrors.ERR_OK;
    }

    public short dump(RpcRequestMessage.DumpNameNodeReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)10, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        System.out.println("#fd\t\tfilecomp\t\tcapacity\t\tisdir\t\t\tdiroffset");
        this.fileTree.dump();
        System.out.println("#fd\t\tfilecomp\t\tcapacity\t\tisdir\t\t\tdiroffset");
        this.dumpFastMap();
        return RpcErrors.ERR_OK;
    }

    public short ping(RpcRequestMessage.PingNameNodeReq request, RpcResponseMessage.PingNameNodeRes response, RpcNameNodeState errorState) throws Exception {
        if (!RpcProtocol.verifyProtocol((short)11, (RpcProtocol.NameNodeRpcMessage)request, (RpcProtocol.NameNodeRpcMessage)response)) {
            return RpcErrors.ERR_PROTOCOL_MISMATCH;
        }
        response.setData(request.getOp() + 1);
        return RpcErrors.ERR_OK;
    }

    void appendToDeleteQueue(AbstractNode fileInfo) throws Exception {
        if (fileInfo != null) {
            fileInfo.setDelay(CrailConstants.TOKEN_EXPIRATION);
            this.deleteQueue.add(fileInfo);
        }
    }

    void freeFile(AbstractNode fileInfo) throws Exception {
        if (fileInfo != null) {
            this.fileTable.remove(fileInfo.getFd());
            fileInfo.freeBlocks(this.blockStore);
        }
    }

    private void dumpFastMap() {
        for (Long key : this.fileTable.keySet()) {
            AbstractNode file = this.fileTable.get(key);
            System.out.println(file.toString());
        }
    }
}

