/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.namenode.LogRecord;
import org.apache.crail.namenode.LogResponse;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class LogService {
    public static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<Long, Long> tokens;
    private FileOutputStream outStream;
    private FileChannel outChannel;
    private ByteBuffer header;
    private ByteBuffer payload;

    public LogService() throws IOException {
        File file = new File(CrailConstants.NAMENODE_LOG);
        if (!file.exists()) {
            file.createNewFile();
        }
        this.outStream = new FileOutputStream(CrailConstants.NAMENODE_LOG, true);
        this.outChannel = this.outStream.getChannel();
        this.header = ByteBuffer.allocate(4);
        this.payload = ByteBuffer.allocate(512);
        this.tokens = new ConcurrentHashMap();
    }

    public void writeRecord(LogRecord record) throws IOException {
        this.payload.clear();
        record.write(this.payload);
        this.payload.flip();
        this.header.clear();
        this.header.putInt(this.payload.remaining());
        this.header.flip();
        this.outChannel.write(this.header);
        while (this.payload.hasRemaining()) {
            this.outChannel.write(this.payload);
        }
    }

    public void replay(RpcNameNodeService service) throws Exception {
        File file = new File(CrailConstants.NAMENODE_LOG);
        if (!file.exists()) {
            return;
        }
        FileInputStream inStream = new FileInputStream(CrailConstants.NAMENODE_LOG);
        FileChannel inChannel = inStream.getChannel();
        LogRecord record = new LogRecord();
        LogResponse response = new LogResponse();
        this.header.clear();
        int ret = inChannel.read(this.header);
        while (ret > 0) {
            this.header.flip();
            int size = this.header.getInt();
            this.payload.clear().limit(size);
            while (this.payload.hasRemaining()) {
                inChannel.read(this.payload);
            }
            this.payload.flip();
            record.update(this.payload);
            this.processServerEvent(service, record, response);
            this.header.clear();
            ret = inChannel.read(this.header);
        }
        inChannel.close();
        inStream.close();
    }

    public void close() throws IOException {
        this.outChannel.close();
        this.outStream.close();
    }

    private void processServerEvent(RpcNameNodeService service, LogRecord record, LogResponse response) {
        short error = RpcErrors.ERR_OK;
        try {
            switch (record.getCmd()) {
                case 1: {
                    error = service.createFile(record.createFile(), response.createFile(), (RpcNameNodeState)response);
                    long fd = response.createFile().getFile().getFd();
                    long token = response.createFile().getFile().getToken();
                    this.tokens.put(response.createFile().getFile().getFd(), response.createFile().getFile().getToken());
                    this.tokens.put(response.createFile().getParent().getFd(), response.createFile().getParent().getToken());
                    break;
                }
                case 3: {
                    record.setFile().getFileInfo().setToken(this.tokens.get(record.setFile().getFileInfo().getFd()).longValue());
                    error = service.setFile(record.setFile(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                case 4: {
                    error = service.removeFile(record.removeFile(), response.delFile(), (RpcNameNodeState)response);
                    break;
                }
                case 5: {
                    error = service.renameFile(record.renameFile(), response.getRename(), (RpcNameNodeState)response);
                    break;
                }
                case 6: {
                    record.getBlock().setToken(this.tokens.get(record.getBlock().getFd()).longValue());
                    error = service.getBlock(record.getBlock(), response.getBlock(), (RpcNameNodeState)response);
                    break;
                }
                case 8: {
                    error = service.setBlock(record.setBlock(), response.getVoid(), (RpcNameNodeState)response);
                    break;
                }
                default: {
                    error = RpcErrors.ERR_INVALID_RPC_CMD;
                    LOG.info("Rpc command not valid, opcode " + record.getCmd());
                    break;
                }
            }
        }
        catch (Exception e) {
            error = RpcErrors.ERR_UNKNOWN;
            LOG.info(RpcErrors.messages[RpcErrors.ERR_UNKNOWN] + e.getMessage());
            e.printStackTrace();
        }
    }
}

