/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class LogRecord {
    public static final Logger LOG = CrailUtils.getLogger();
    public static final int CSIZE = 4 + Math.max(RpcRequestMessage.SetFileReq.CSIZE, RpcRequestMessage.RenameFileReq.CSIZE);
    private short cmd;
    private short type;
    private RpcRequestMessage.CreateFileReq createFileReq;
    private RpcRequestMessage.GetFileReq fileReq;
    private RpcRequestMessage.SetFileReq setFileReq;
    private RpcRequestMessage.RemoveFileReq removeReq;
    private RpcRequestMessage.RenameFileReq renameFileReq;
    private RpcRequestMessage.GetBlockReq getBlockReq;
    private RpcRequestMessage.GetLocationReq getLocationReq;
    private RpcRequestMessage.SetBlockReq setBlockReq;
    private RpcRequestMessage.GetDataNodeReq getDataNodeReq;
    private RpcRequestMessage.DumpNameNodeReq dumpNameNodeReq;
    private RpcRequestMessage.PingNameNodeReq pingNameNodeReq;

    public LogRecord() {
        this.cmd = 0;
        this.type = 0;
        this.createFileReq = new RpcRequestMessage.CreateFileReq();
        this.fileReq = new RpcRequestMessage.GetFileReq();
        this.setFileReq = new RpcRequestMessage.SetFileReq();
        this.removeReq = new RpcRequestMessage.RemoveFileReq();
        this.renameFileReq = new RpcRequestMessage.RenameFileReq();
        this.getBlockReq = new RpcRequestMessage.GetBlockReq();
        this.getLocationReq = new RpcRequestMessage.GetLocationReq();
        this.setBlockReq = new RpcRequestMessage.SetBlockReq();
        this.dumpNameNodeReq = new RpcRequestMessage.DumpNameNodeReq();
        this.pingNameNodeReq = new RpcRequestMessage.PingNameNodeReq();
        this.getDataNodeReq = new RpcRequestMessage.GetDataNodeReq();
    }

    public LogRecord(RpcRequestMessage.CreateFileReq message) {
        this.type = message.getType();
        this.createFileReq = message;
    }

    public LogRecord(RpcRequestMessage.GetFileReq message) {
        this.type = message.getType();
        this.fileReq = message;
    }

    public LogRecord(RpcRequestMessage.SetFileReq message) {
        this.type = message.getType();
        this.setFileReq = message;
    }

    public LogRecord(RpcRequestMessage.RemoveFileReq message) {
        this.type = message.getType();
        this.removeReq = message;
    }

    public LogRecord(RpcRequestMessage.RenameFileReq message) {
        this.type = message.getType();
        this.renameFileReq = message;
    }

    public LogRecord(RpcRequestMessage.GetBlockReq message) {
        this.type = message.getType();
        this.getBlockReq = message;
    }

    public LogRecord(RpcRequestMessage.GetLocationReq message) {
        this.type = message.getType();
        this.getLocationReq = message;
    }

    public LogRecord(RpcRequestMessage.SetBlockReq message) {
        this.type = message.getType();
        this.setBlockReq = message;
    }

    public LogRecord(RpcRequestMessage.GetDataNodeReq message) {
        this.type = message.getType();
        this.getDataNodeReq = message;
    }

    public LogRecord(RpcRequestMessage.DumpNameNodeReq message) {
        this.type = message.getType();
        this.dumpNameNodeReq = message;
    }

    public LogRecord(RpcRequestMessage.PingNameNodeReq message) {
        this.type = message.getType();
        this.pingNameNodeReq = message;
    }

    public void setCommand(short command) {
        this.cmd = command;
    }

    public int size() {
        return CSIZE;
    }

    public int write(ByteBuffer buffer) throws IOException {
        buffer.putShort(this.cmd);
        buffer.putShort(this.type);
        int written = 4;
        switch (this.type) {
            case 1: {
                written += this.createFileReq.write(buffer);
                break;
            }
            case 2: {
                written += this.fileReq.write(buffer);
                break;
            }
            case 3: {
                written += this.setFileReq.write(buffer);
                break;
            }
            case 4: {
                written += this.removeReq.write(buffer);
                break;
            }
            case 5: {
                written += this.renameFileReq.write(buffer);
                break;
            }
            case 6: {
                written += this.getBlockReq.write(buffer);
                break;
            }
            case 7: {
                written += this.getLocationReq.write(buffer);
                break;
            }
            case 8: {
                written += this.setBlockReq.write(buffer);
                break;
            }
            case 12: {
                written += this.getDataNodeReq.write(buffer);
                break;
            }
            case 10: {
                written += this.dumpNameNodeReq.write(buffer);
                break;
            }
            case 11: {
                written += this.pingNameNodeReq.write(buffer);
            }
        }
        return written;
    }

    public void update(ByteBuffer buffer) throws IOException {
        this.cmd = buffer.getShort();
        this.type = buffer.getShort();
        switch (this.type) {
            case 1: {
                this.createFileReq.update(buffer);
                break;
            }
            case 2: {
                this.fileReq.update(buffer);
                break;
            }
            case 3: {
                this.setFileReq.update(buffer);
                break;
            }
            case 4: {
                this.removeReq.update(buffer);
                break;
            }
            case 5: {
                this.renameFileReq.update(buffer);
                break;
            }
            case 6: {
                this.getBlockReq.update(buffer);
                break;
            }
            case 7: {
                this.getLocationReq.update(buffer);
                break;
            }
            case 8: {
                this.setBlockReq.update(buffer);
                break;
            }
            case 12: {
                this.getDataNodeReq.update(buffer);
                break;
            }
            case 10: {
                this.dumpNameNodeReq.update(buffer);
                break;
            }
            case 11: {
                this.pingNameNodeReq.update(buffer);
            }
        }
    }

    public short getCmd() {
        return this.cmd;
    }

    public short getType() {
        return this.type;
    }

    public RpcRequestMessage.CreateFileReq createFile() {
        return this.createFileReq;
    }

    public RpcRequestMessage.GetFileReq getFile() {
        return this.fileReq;
    }

    public RpcRequestMessage.SetFileReq setFile() {
        return this.setFileReq;
    }

    public RpcRequestMessage.RemoveFileReq removeFile() {
        return this.removeReq;
    }

    public RpcRequestMessage.RenameFileReq renameFile() {
        return this.renameFileReq;
    }

    public RpcRequestMessage.GetBlockReq getBlock() {
        return this.getBlockReq;
    }

    public RpcRequestMessage.GetLocationReq getLocation() {
        return this.getLocationReq;
    }

    public RpcRequestMessage.SetBlockReq setBlock() {
        return this.setBlockReq;
    }

    public RpcRequestMessage.GetDataNodeReq getDataNode() {
        return this.getDataNodeReq;
    }

    public RpcRequestMessage.DumpNameNodeReq dumpNameNode() {
        return this.dumpNameNodeReq;
    }

    public RpcRequestMessage.PingNameNodeReq pingNameNode() {
        return this.pingNameNodeReq;
    }

    public String toString() {
        String message = "";
        switch (this.type) {
            case 1: {
                message = message + this.createFileReq.toString();
                break;
            }
            case 2: {
                message = message + this.fileReq.toString();
                break;
            }
            case 3: {
                message = message + this.setFileReq.toString();
                break;
            }
            case 4: {
                message = message + this.removeReq.toString();
                break;
            }
            case 5: {
                message = message + this.renameFileReq.toString();
                break;
            }
            case 6: {
                message = message + this.getBlockReq.toString();
                break;
            }
            case 7: {
                message = message + this.getLocationReq.toString();
                break;
            }
            case 8: {
                message = message + this.setBlockReq.toString();
                break;
            }
            case 12: {
                message = message + this.getDataNodeReq.toString();
                break;
            }
            case 10: {
                message = message + this.dumpNameNodeReq.toString();
                break;
            }
            case 11: {
                message = message + this.pingNameNodeReq.toString();
            }
        }
        return message;
    }
}

