/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import org.apache.crail.namenode.LogRecord;
import org.apache.crail.namenode.LogService;
import org.apache.crail.rpc.RpcNameNodeService;
import org.apache.crail.rpc.RpcNameNodeState;
import org.apache.crail.rpc.RpcRequestMessage;
import org.apache.crail.rpc.RpcResponseMessage;

public class LogDispatcher
implements RpcNameNodeService {
    private RpcNameNodeService service;
    private LogService logService;

    public LogDispatcher(RpcNameNodeService service) throws Exception {
        this.service = service;
        this.logService = new LogService();
        this.logService.replay(service);
    }

    public short createFile(RpcRequestMessage.CreateFileReq request, RpcResponseMessage.CreateFileRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)1);
        this.logService.writeRecord(record);
        return this.service.createFile(request, response, errorState);
    }

    public short getFile(RpcRequestMessage.GetFileReq request, RpcResponseMessage.GetFileRes response, RpcNameNodeState errorState) throws Exception {
        return this.service.getFile(request, response, errorState);
    }

    public short setFile(RpcRequestMessage.SetFileReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)3);
        this.logService.writeRecord(record);
        return this.service.setFile(request, response, errorState);
    }

    public short removeFile(RpcRequestMessage.RemoveFileReq request, RpcResponseMessage.DeleteFileRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)4);
        this.logService.writeRecord(record);
        return this.service.removeFile(request, response, errorState);
    }

    public short renameFile(RpcRequestMessage.RenameFileReq request, RpcResponseMessage.RenameRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)5);
        this.logService.writeRecord(record);
        return this.service.renameFile(request, response, errorState);
    }

    public short getDataNode(RpcRequestMessage.GetDataNodeReq request, RpcResponseMessage.GetDataNodeRes response, RpcNameNodeState errorState) throws Exception {
        return this.service.getDataNode(request, response, errorState);
    }

    public short setBlock(RpcRequestMessage.SetBlockReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)8);
        this.logService.writeRecord(record);
        return this.service.setBlock(request, response, errorState);
    }

    public short getBlock(RpcRequestMessage.GetBlockReq request, RpcResponseMessage.GetBlockRes response, RpcNameNodeState errorState) throws Exception {
        LogRecord record = new LogRecord(request);
        record.setCommand((short)6);
        this.logService.writeRecord(record);
        return this.service.getBlock(request, response, errorState);
    }

    public short getLocation(RpcRequestMessage.GetLocationReq request, RpcResponseMessage.GetLocationRes response, RpcNameNodeState errorState) throws Exception {
        return this.service.getLocation(request, response, errorState);
    }

    public short dump(RpcRequestMessage.DumpNameNodeReq request, RpcResponseMessage.VoidRes response, RpcNameNodeState errorState) throws Exception {
        return this.service.dump(request, response, errorState);
    }

    public short ping(RpcRequestMessage.PingNameNodeReq request, RpcResponseMessage.PingNameNodeRes response, RpcNameNodeState errorState) throws Exception {
        return this.service.ping(request, response, errorState);
    }
}

