/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.util.concurrent.DelayQueue;
import org.apache.crail.namenode.AbstractNode;
import org.apache.crail.namenode.NameNodeService;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class GCServer
implements Runnable {
    private static final Logger LOG = CrailUtils.getLogger();
    private NameNodeService rpcService;
    private DelayQueue<AbstractNode> deleteQueue;

    public GCServer(NameNodeService service, DelayQueue<AbstractNode> deleteQueue) {
        this.rpcService = service;
        this.deleteQueue = deleteQueue;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    AbstractNode file;
                    if ((file = (AbstractNode)this.deleteQueue.take()).getType().isContainer()) {
                        file.clearChildren(this.deleteQueue);
                    }
                    this.rpcService.freeFile(file);
                }
            }
            catch (Exception e) {
                LOG.info("Exception during GC: " + e.getMessage());
                continue;
            }
            break;
        }
    }
}

