/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.io.IOException;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.FileName;
import org.apache.crail.namenode.AbstractNode;
import org.apache.crail.namenode.DirectoryBlocks;
import org.apache.crail.namenode.FileBlocks;
import org.apache.crail.namenode.KeyValueBlocks;
import org.apache.crail.namenode.MultiFileBlocks;
import org.apache.crail.namenode.Sequencer;
import org.apache.crail.namenode.TableBlocks;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.rpc.RpcNameNodeState;

public class FileStore {
    private Sequencer sequencer;
    private AbstractNode root;

    public FileStore(Sequencer sequencer) throws IOException {
        this.sequencer = sequencer;
        this.root = this.createNode(new FileName("/").getFileComponent(), CrailNodeType.DIRECTORY, CrailConstants.STORAGE_ROOTCLASS, 0, false);
    }

    public AbstractNode createNode(int fileComponent, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) throws IOException {
        if (type == CrailNodeType.DIRECTORY) {
            return new DirectoryBlocks(this.sequencer.getNextId(), fileComponent, type, storageClass, locationClass, enumerable);
        }
        if (type == CrailNodeType.MULTIFILE) {
            return new MultiFileBlocks(this.sequencer.getNextId(), fileComponent, type, storageClass, locationClass, enumerable);
        }
        if (type == CrailNodeType.TABLE) {
            return new TableBlocks(this.sequencer.getNextId(), fileComponent, type, storageClass, locationClass, enumerable);
        }
        if (type == CrailNodeType.KEYVALUE) {
            return new KeyValueBlocks(this.sequencer.getNextId(), fileComponent, type, storageClass, locationClass, enumerable);
        }
        if (type == CrailNodeType.DATAFILE) {
            return new FileBlocks(this.sequencer.getNextId(), fileComponent, type, storageClass, locationClass, enumerable);
        }
        throw new IOException("File type unkown: " + type);
    }

    public AbstractNode retrieveFile(FileName filename, RpcNameNodeState error) throws Exception {
        return this.retrieveFileInternal(filename, filename.getLength(), error);
    }

    public AbstractNode retrieveParent(FileName filename, RpcNameNodeState error) throws Exception {
        return this.retrieveFileInternal(filename, filename.getLength() - 1, error);
    }

    public AbstractNode getRoot() {
        return this.root;
    }

    public void dump() {
        this.root.dump();
    }

    private AbstractNode retrieveFileInternal(FileName filename, int length, RpcNameNodeState error) throws Exception {
        int component;
        if (length >= CrailConstants.DIRECTORY_DEPTH) {
            error.setError(RpcErrors.ERR_FILE_COMPONENTS_EXCEEDED);
            return null;
        }
        AbstractNode current = this.root;
        for (int i = 0; i < length && (current = current.getChild(component = filename.getComponent(i))) != null; ++i) {
        }
        return current;
    }
}

