/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.namenode.AbstractNode;
import org.apache.crail.namenode.BlockStore;
import org.apache.crail.namenode.NameNodeBlockInfo;

public class FileBlocks
extends AbstractNode {
    private ArrayList<NameNodeBlockInfo> blocks = new ArrayList(CrailConstants.NAMENODE_FILEBLOCKS);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public FileBlocks(long fd, int fileComponent, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) {
        super(fd, fileComponent, type, storageClass, locationClass, enumerable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameNodeBlockInfo getBlock(int index) {
        this.readLock.lock();
        try {
            if (index < this.blocks.size()) {
                NameNodeBlockInfo nameNodeBlockInfo = this.blocks.get(index);
                return nameNodeBlockInfo;
            }
            NameNodeBlockInfo nameNodeBlockInfo = null;
            return nameNodeBlockInfo;
        }
        catch (Exception e) {
            NameNodeBlockInfo nameNodeBlockInfo = null;
            return nameNodeBlockInfo;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBlock(int index, NameNodeBlockInfo block) {
        this.writeLock.lock();
        try {
            if (index == this.blocks.size()) {
                this.blocks.add(index, block);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeBlocks(BlockStore blockStore) throws Exception {
        this.readLock.lock();
        try {
            for (NameNodeBlockInfo blockInfo : this.blocks) {
                blockStore.addBlock(blockInfo);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public AbstractNode putChild(AbstractNode child) throws Exception {
        throw new Exception("Attempt to add a child to a non-container type");
    }

    @Override
    public AbstractNode getChild(int component) throws Exception {
        throw new Exception("Attempto to retrieve child from non-container type");
    }

    @Override
    public AbstractNode removeChild(int component) throws Exception {
        throw new Exception("Attempt to remove child from non-container type");
    }

    @Override
    public void clearChildren(Queue<AbstractNode> queue) throws Exception {
        throw new Exception("Attempt collect children from non-container type");
    }
}

