/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.crail.CrailNodeType;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.namenode.AbstractNode;
import org.apache.crail.namenode.BlockStore;
import org.apache.crail.namenode.NameNodeBlockInfo;

public class DirectoryBlocks
extends AbstractNode {
    protected AtomicLong dirOffsetCounter;
    protected ConcurrentHashMap<Integer, AbstractNode> children = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, NameNodeBlockInfo> blocks;

    DirectoryBlocks(long fd, int fileComponent, CrailNodeType type, int storageClass, int locationClass, boolean enumerable) {
        super(fd, fileComponent, type, storageClass, locationClass, enumerable);
        this.dirOffsetCounter = new AtomicLong(0L);
        this.blocks = new ConcurrentHashMap();
    }

    @Override
    public AbstractNode putChild(AbstractNode child) throws Exception {
        AbstractNode old = this.children.putIfAbsent(child.getComponent(), child);
        if (old != null) {
            throw new Exception("File exists");
        }
        if (child.isEnumerable()) {
            child.setDirOffset(this.dirOffsetCounter.getAndAdd(CrailConstants.DIRECTORY_RECORD));
        }
        return old;
    }

    @Override
    public AbstractNode getChild(int component) {
        return this.children.get(component);
    }

    @Override
    public AbstractNode removeChild(int component) {
        return this.children.remove(component);
    }

    @Override
    public NameNodeBlockInfo getBlock(int index) {
        return this.blocks.get(index);
    }

    @Override
    public boolean addBlock(int index, NameNodeBlockInfo block) {
        BlockInfo old = this.blocks.putIfAbsent(index, block);
        return old == null;
    }

    @Override
    public void freeBlocks(BlockStore blockStore) throws Exception {
        for (NameNodeBlockInfo blockInfo : this.blocks.values()) {
            blockStore.addBlock(blockInfo);
        }
    }

    public long setCapacity(long newcapacity) {
        return this.getCapacity();
    }

    public void updateToken() {
    }

    @Override
    public void clearChildren(Queue<AbstractNode> queue) {
        for (AbstractNode child : this.children.values()) {
            queue.add(child);
        }
    }

    @Override
    public void dump() {
        super.dump();
        for (AbstractNode child : this.children.values()) {
            child.dump();
        }
    }
}

