/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.net.UnknownHostException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.namenode.NameNodeBlockInfo;
import org.apache.crail.rpc.RpcErrors;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class DataNodeBlocks
extends DataNodeInfo {
    private static final Logger LOG = CrailUtils.getLogger();
    private ConcurrentHashMap<Long, BlockInfo> regions = new ConcurrentHashMap();
    private LinkedBlockingQueue<NameNodeBlockInfo> freeBlocks = new LinkedBlockingQueue();
    private long token;

    public static DataNodeBlocks fromDataNodeInfo(DataNodeInfo dnInfo) throws UnknownHostException {
        DataNodeBlocks dnInfoNn = new DataNodeBlocks(dnInfo.getStorageType(), dnInfo.getStorageClass(), dnInfo.getLocationClass(), dnInfo.getIpAddress(), dnInfo.getPort());
        return dnInfoNn;
    }

    private DataNodeBlocks(int storageType, int getStorageClass, int locationClass, byte[] ipAddress, int port) throws UnknownHostException {
        super(storageType, getStorageClass, locationClass, ipAddress, port);
    }

    public void addFreeBlock(NameNodeBlockInfo nnBlock) {
        this.regions.put(nnBlock.getRegion().getLba(), nnBlock.getRegion());
        this.freeBlocks.add(nnBlock);
    }

    public NameNodeBlockInfo getFreeBlock() throws InterruptedException {
        NameNodeBlockInfo block = this.freeBlocks.poll();
        return block;
    }

    public int getBlockCount() {
        return this.freeBlocks.size();
    }

    public boolean regionExists(BlockInfo region) {
        return this.regions.containsKey(region.getLba());
    }

    public short updateRegion(BlockInfo region) {
        BlockInfo oldRegion = this.regions.get(region.getLba());
        if (oldRegion == null) {
            return RpcErrors.ERR_ADD_BLOCK_FAILED;
        }
        oldRegion.setBlockInfo(region);
        return 0;
    }

    public void touch() {
        this.token = System.nanoTime() + TimeUnit.SECONDS.toNanos(CrailConstants.STORAGE_KEEPALIVE * 8);
    }

    public boolean isOnline() {
        return System.nanoTime() <= this.token;
    }
}

