/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.net.UnknownHostException;
import org.apache.crail.conf.CrailConstants;
import org.apache.crail.metadata.BlockInfo;
import org.apache.crail.metadata.DataNodeInfo;
import org.apache.crail.namenode.DataNodeBlocks;
import org.apache.crail.namenode.NameNodeBlockInfo;
import org.apache.crail.namenode.StorageClass;
import org.apache.crail.utils.CrailUtils;
import org.slf4j.Logger;

public class BlockStore {
    private static final Logger LOG = CrailUtils.getLogger();
    private StorageClass[] storageClasses = new StorageClass[CrailConstants.STORAGE_CLASSES];

    public BlockStore() {
        for (int i = 0; i < CrailConstants.STORAGE_CLASSES; ++i) {
            this.storageClasses[i] = new StorageClass(i);
        }
    }

    public short addBlock(NameNodeBlockInfo blockInfo) throws UnknownHostException {
        int storageClass = blockInfo.getDnInfo().getStorageClass();
        return this.storageClasses[storageClass].addBlock(blockInfo);
    }

    public boolean regionExists(BlockInfo region) {
        int storageClass = region.getDnInfo().getStorageClass();
        return this.storageClasses[storageClass].regionExists(region);
    }

    public short updateRegion(BlockInfo region) {
        int storageClass = region.getDnInfo().getStorageClass();
        return this.storageClasses[storageClass].updateRegion(region);
    }

    public NameNodeBlockInfo getBlock(int storageClass, int locationAffinity) throws InterruptedException {
        NameNodeBlockInfo block = null;
        if (storageClass > 0 && storageClass < this.storageClasses.length) {
            block = this.storageClasses[storageClass].getBlock(locationAffinity);
        }
        if (block == null) {
            for (int i = 0; i < this.storageClasses.length && (block = this.storageClasses[i].getBlock(locationAffinity)) == null; ++i) {
            }
        }
        return block;
    }

    public DataNodeBlocks getDataNode(DataNodeInfo dnInfo) {
        int storageClass = dnInfo.getStorageClass();
        return this.storageClasses[storageClass].getDataNode(dnInfo);
    }
}

