/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crail.namenode;

import java.util.Queue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.crail.CrailNodeType;
import org.apache.crail.metadata.FileInfo;
import org.apache.crail.namenode.BlockStore;
import org.apache.crail.namenode.NameNodeBlockInfo;

public abstract class AbstractNode
extends FileInfo
implements Delayed {
    private int fileComponent;
    private long delay;
    private int storageClass;
    private int locationClass;

    public abstract AbstractNode putChild(AbstractNode var1) throws Exception;

    public abstract AbstractNode getChild(int var1) throws Exception;

    public abstract AbstractNode removeChild(int var1) throws Exception;

    public abstract void clearChildren(Queue<AbstractNode> var1) throws Exception;

    public abstract boolean addBlock(int var1, NameNodeBlockInfo var2) throws Exception;

    public abstract NameNodeBlockInfo getBlock(int var1) throws Exception;

    public abstract void freeBlocks(BlockStore var1) throws Exception;

    public AbstractNode(long fd, int fileComponent, CrailNodeType type, int storageClass, int locationAffinity, boolean enumerable) {
        super(fd, type, enumerable);
        this.fileComponent = fileComponent;
        this.storageClass = storageClass;
        this.locationClass = locationAffinity;
        this.delay = System.currentTimeMillis();
        this.setModificationTime(System.currentTimeMillis());
    }

    void rename(int newFileComponent) throws Exception {
        this.fileComponent = newFileComponent;
    }

    public int getComponent() {
        return this.fileComponent;
    }

    public void dump() {
        System.out.println(this.toString());
    }

    protected void setDirOffset(long dirOffset) {
        super.setDirOffset(dirOffset);
    }

    public String toString() {
        return String.format("%08d\t%08d\t\t%08d\t\t%08d\t\t%08d", this.getFd(), this.fileComponent, this.getCapacity(), this.getType().getLabel(), this.getDirOffset());
    }

    @Override
    public long getDelay(TimeUnit unit) {
        long diff = this.delay - System.currentTimeMillis();
        long _delay = unit.convert(diff, TimeUnit.MILLISECONDS);
        return _delay;
    }

    public void setDelay(long delay) {
        this.delay = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(delay);
    }

    @Override
    public int compareTo(Delayed o) {
        return 0;
    }

    public int getStorageClass() {
        return this.storageClass;
    }

    public int getLocationClass() {
        return this.locationClass;
    }
}

