/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.ArrayList;
import org.apache.hadoop.test.UnitTestcaseTimeLimit;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestStringUtils
extends UnitTestcaseTimeLimit {
    private static final String NULL_STR = null;
    private static final String EMPTY_STR = "";
    private static final String STR_WO_SPECIAL_CHARS = "AB";
    private static final String STR_WITH_COMMA = "A,B";
    private static final String ESCAPED_STR_WITH_COMMA = "A\\,B";
    private static final String STR_WITH_ESCAPE = "AB\\";
    private static final String ESCAPED_STR_WITH_ESCAPE = "AB\\\\";
    private static final String STR_WITH_BOTH2 = ",A\\,,B\\\\,";
    private static final String ESCAPED_STR_WITH_BOTH2 = "\\,A\\\\\\,\\,B\\\\\\\\\\,";
    public static final String __PARANAMER_DATA = "main java.lang.String[] args \n";

    @Test
    public void testEscapeString() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.escapeString((String)NULL_STR));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.escapeString((String)EMPTY_STR));
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.escapeString((String)STR_WO_SPECIAL_CHARS));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)StringUtils.escapeString((String)STR_WITH_COMMA));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_ESCAPE, (Object)StringUtils.escapeString((String)STR_WITH_ESCAPE));
        Assert.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)StringUtils.escapeString((String)STR_WITH_BOTH2));
    }

    @Test
    public void testSplit() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.split((String)NULL_STR));
        String[] splits = StringUtils.split((String)EMPTY_STR);
        Assert.assertEquals((long)0L, (long)splits.length);
        splits = StringUtils.split((String)",,");
        Assert.assertEquals((long)0L, (long)splits.length);
        splits = StringUtils.split((String)STR_WO_SPECIAL_CHARS);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_COMMA);
        Assert.assertEquals((long)2L, (long)splits.length);
        Assert.assertEquals((Object)"A", (Object)splits[0]);
        Assert.assertEquals((Object)"B", (Object)splits[1]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_COMMA);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)ESCAPED_STR_WITH_COMMA, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_ESCAPE);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)STR_WITH_ESCAPE, (Object)splits[0]);
        splits = StringUtils.split((String)STR_WITH_BOTH2);
        Assert.assertEquals((long)3L, (long)splits.length);
        Assert.assertEquals((Object)EMPTY_STR, (Object)splits[0]);
        Assert.assertEquals((Object)"A\\,", (Object)splits[1]);
        Assert.assertEquals((Object)"B\\\\", (Object)splits[2]);
        splits = StringUtils.split((String)ESCAPED_STR_WITH_BOTH2);
        Assert.assertEquals((long)1L, (long)splits.length);
        Assert.assertEquals((Object)ESCAPED_STR_WITH_BOTH2, (Object)splits[0]);
    }

    @Test
    public void testSimpleSplit() throws Exception {
        String[] TO_TEST;
        for (String testSubject : TO_TEST = new String[]{"a/b/c", "a/b/c////", "///a/b/c", EMPTY_STR, "/", "////"}) {
            Assert.assertArrayEquals((String)("Testing '" + testSubject + "'"), (Object[])testSubject.split("/"), (Object[])StringUtils.split((String)testSubject, (char)'/'));
        }
    }

    @Test
    public void testUnescapeString() throws Exception {
        Assert.assertEquals((Object)NULL_STR, (Object)StringUtils.unEscapeString((String)NULL_STR));
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.unEscapeString((String)EMPTY_STR));
        Assert.assertEquals((Object)STR_WO_SPECIAL_CHARS, (Object)StringUtils.unEscapeString((String)STR_WO_SPECIAL_CHARS));
        try {
            StringUtils.unEscapeString((String)STR_WITH_COMMA);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_COMMA, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_COMMA));
        try {
            StringUtils.unEscapeString((String)STR_WITH_ESCAPE);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_ESCAPE, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_ESCAPE));
        try {
            StringUtils.unEscapeString((String)STR_WITH_BOTH2);
            Assert.fail((String)"Should throw IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((Object)STR_WITH_BOTH2, (Object)StringUtils.unEscapeString((String)ESCAPED_STR_WITH_BOTH2));
    }

    @Test
    public void testTraditionalBinaryPrefix() throws Exception {
        String[] symbol = new String[]{"k", "m", "g", "t", "p", "e"};
        long m = 1024L;
        for (String s : symbol) {
            Assert.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(0 + s)));
            Assert.assertEquals((long)m, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)(1 + s)));
            m *= 1024L;
        }
        Assert.assertEquals((long)0L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"0"));
        Assert.assertEquals((long)-1259520L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"-1230k"));
        Assert.assertEquals((long)956703965184L, (long)StringUtils.TraditionalBinaryPrefix.string2long((String)"891g"));
    }

    @Test
    public void testJoin() {
        ArrayList<String> s = new ArrayList<String>();
        s.add("a");
        s.add("b");
        s.add("c");
        Assert.assertEquals((Object)EMPTY_STR, (Object)StringUtils.join((CharSequence)":", s.subList(0, 0)));
        Assert.assertEquals((Object)"a", (Object)StringUtils.join((CharSequence)":", s.subList(0, 1)));
        Assert.assertEquals((Object)"a:b", (Object)StringUtils.join((CharSequence)":", s.subList(0, 2)));
        Assert.assertEquals((Object)"a:b:c", (Object)StringUtils.join((CharSequence)":", s.subList(0, 3)));
    }

    @Test
    public void testGetTrimmedStrings() throws Exception {
        String compactDirList = "/spindle1/hdfs,/spindle2/hdfs,/spindle3/hdfs";
        String spacedDirList = "/spindle1/hdfs, /spindle2/hdfs, /spindle3/hdfs";
        String pathologicalDirList1 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs ";
        String pathologicalDirList2 = " /spindle1/hdfs  ,  /spindle2/hdfs ,/spindle3/hdfs , ";
        String emptyList1 = EMPTY_STR;
        String emptyList2 = "   ";
        Object[] expectedArray = new String[]{"/spindle1/hdfs", "/spindle2/hdfs", "/spindle3/hdfs"};
        Object[] emptyArray = new String[]{};
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)compactDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)spacedDirList));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList1));
        Assert.assertArrayEquals((Object[])expectedArray, (Object[])StringUtils.getTrimmedStrings((String)pathologicalDirList2));
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList1));
        Assert.assertArrayEquals((Object[])emptyArray, (Object[])StringUtils.getTrimmedStrings((String)emptyList2));
    }

    @Test
    public void testCamelize() {
        Assert.assertEquals((Object)"Map", (Object)StringUtils.camelize((String)"MAP"));
        Assert.assertEquals((Object)"JobSetup", (Object)StringUtils.camelize((String)"JOB_SETUP"));
        Assert.assertEquals((Object)"SomeStuff", (Object)StringUtils.camelize((String)"some_stuff"));
        Assert.assertEquals((Object)"Aa", (Object)StringUtils.camelize((String)"aA"));
        Assert.assertEquals((Object)"Bb", (Object)StringUtils.camelize((String)"bB"));
        Assert.assertEquals((Object)"Cc", (Object)StringUtils.camelize((String)"cC"));
        Assert.assertEquals((Object)"Dd", (Object)StringUtils.camelize((String)"dD"));
        Assert.assertEquals((Object)"Ee", (Object)StringUtils.camelize((String)"eE"));
        Assert.assertEquals((Object)"Ff", (Object)StringUtils.camelize((String)"fF"));
        Assert.assertEquals((Object)"Gg", (Object)StringUtils.camelize((String)"gG"));
        Assert.assertEquals((Object)"Hh", (Object)StringUtils.camelize((String)"hH"));
        Assert.assertEquals((Object)"Ii", (Object)StringUtils.camelize((String)"iI"));
        Assert.assertEquals((Object)"Jj", (Object)StringUtils.camelize((String)"jJ"));
        Assert.assertEquals((Object)"Kk", (Object)StringUtils.camelize((String)"kK"));
        Assert.assertEquals((Object)"Ll", (Object)StringUtils.camelize((String)"lL"));
        Assert.assertEquals((Object)"Mm", (Object)StringUtils.camelize((String)"mM"));
        Assert.assertEquals((Object)"Nn", (Object)StringUtils.camelize((String)"nN"));
        Assert.assertEquals((Object)"Oo", (Object)StringUtils.camelize((String)"oO"));
        Assert.assertEquals((Object)"Pp", (Object)StringUtils.camelize((String)"pP"));
        Assert.assertEquals((Object)"Qq", (Object)StringUtils.camelize((String)"qQ"));
        Assert.assertEquals((Object)"Rr", (Object)StringUtils.camelize((String)"rR"));
        Assert.assertEquals((Object)"Ss", (Object)StringUtils.camelize((String)"sS"));
        Assert.assertEquals((Object)"Tt", (Object)StringUtils.camelize((String)"tT"));
        Assert.assertEquals((Object)"Uu", (Object)StringUtils.camelize((String)"uU"));
        Assert.assertEquals((Object)"Vv", (Object)StringUtils.camelize((String)"vV"));
        Assert.assertEquals((Object)"Ww", (Object)StringUtils.camelize((String)"wW"));
        Assert.assertEquals((Object)"Xx", (Object)StringUtils.camelize((String)"xX"));
        Assert.assertEquals((Object)"Yy", (Object)StringUtils.camelize((String)"yY"));
        Assert.assertEquals((Object)"Zz", (Object)StringUtils.camelize((String)"zZ"));
    }

    public static void main(String[] args) {
        String TO_SPLIT = "foo,bar,baz,blah,blah";
        for (boolean useOurs : new boolean[]{false, true}) {
            for (int outer = 0; outer < 10; ++outer) {
                long st = System.nanoTime();
                int components = 0;
                for (int inner = 0; inner < 1000000; ++inner) {
                    String[] res = useOurs ? StringUtils.split((String)"foo,bar,baz,blah,blah", (char)',') : "foo,bar,baz,blah,blah".split(",");
                    components += res.length;
                }
                long et = System.nanoTime();
                if (outer <= 3) continue;
                System.out.println((useOurs ? "StringUtils impl" : "Java impl") + " #" + outer + ":" + (et - st) / 1000000L + "ms");
            }
        }
    }
}

