/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;

public class TestAccessControlList
extends TestCase {
    public static final String __PARANAMER_DATA = "";

    public void testWildCardAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("*");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("  * ");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList(" *");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        acl = new AccessControlList("*  ");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
    }

    public void testAclString() {
        AccessControlList acl = new AccessControlList("*");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("All users are allowed"));
        this.validateGetAclString(acl);
        acl = new AccessControlList(" ");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("No users are allowed"));
        acl = new AccessControlList("user1,user2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] are allowed"));
        this.validateGetAclString(acl);
        acl = new AccessControlList("user1,user2 ");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] are allowed"));
        this.validateGetAclString(acl);
        acl = new AccessControlList(" group1,group2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Members of the groups [group1, group2] are allowed"));
        this.validateGetAclString(acl);
        acl = new AccessControlList("user1,user2 group1,group2");
        TestAccessControlList.assertTrue((boolean)acl.toString().equals("Users [user1, user2] and members of the groups [group1, group2] are allowed"));
        this.validateGetAclString(acl);
    }

    private void validateGetAclString(AccessControlList acl) {
        TestAccessControlList.assertTrue((boolean)acl.toString().equals(new AccessControlList(acl.getAclString()).toString()));
    }

    public void testAccessControlList() throws Exception {
        AccessControlList acl = new AccessControlList("drwho tardis");
        Set users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        Set groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new AccessControlList("drwho");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new AccessControlList("drwho ");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)0);
        acl = new AccessControlList(" tardis");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)0);
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        acl = new AccessControlList("drwho,joe tardis, users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)2);
        Iterator iter = users.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"joe");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)2);
        iter = groups.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"users");
    }

    public void testAddRemoveAPI() {
        AccessControlList acl = new AccessControlList(" ");
        TestAccessControlList.assertEquals((int)0, (int)acl.getUsers().size());
        TestAccessControlList.assertEquals((int)0, (int)acl.getGroups().size());
        TestAccessControlList.assertEquals((String)" ", (String)acl.getAclString());
        acl.addUser("drwho");
        Set users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)users.iterator().next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)"drwho ", (String)acl.getAclString());
        acl.addGroup("tardis");
        Set groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertEquals((String)((String)groups.iterator().next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)"drwho tardis", (String)acl.getAclString());
        acl.addUser("joe");
        acl.addGroup("users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)2);
        Iterator iter = users.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"drwho");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"joe");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)2);
        iter = groups.iterator();
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"tardis");
        TestAccessControlList.assertEquals((String)((String)iter.next()), (String)"users");
        TestAccessControlList.assertEquals((String)"drwho,joe tardis,users", (String)acl.getAclString());
        acl.removeUser("joe");
        acl.removeGroup("users");
        users = acl.getUsers();
        TestAccessControlList.assertEquals((int)users.size(), (int)1);
        TestAccessControlList.assertFalse((boolean)users.contains("joe"));
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)groups.size(), (int)1);
        TestAccessControlList.assertFalse((boolean)groups.contains("users"));
        TestAccessControlList.assertEquals((String)"drwho tardis", (String)acl.getAclString());
        acl.removeGroup("tardis");
        groups = acl.getGroups();
        TestAccessControlList.assertEquals((int)0, (int)groups.size());
        TestAccessControlList.assertFalse((boolean)groups.contains("tardis"));
        TestAccessControlList.assertEquals((String)"drwho ", (String)acl.getAclString());
        acl.removeUser("drwho");
        TestAccessControlList.assertEquals((int)0, (int)users.size());
        TestAccessControlList.assertFalse((boolean)users.contains("drwho"));
        TestAccessControlList.assertEquals((int)0, (int)acl.getGroups().size());
        TestAccessControlList.assertEquals((int)0, (int)acl.getUsers().size());
        TestAccessControlList.assertEquals((String)" ", (String)acl.getAclString());
    }

    public void testAddRemoveWildCard() {
        AccessControlList acl = new AccessControlList("drwho tardis");
        Throwable th = null;
        try {
            acl.addUser(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        TestAccessControlList.assertNotNull((Object)th);
        TestAccessControlList.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.addGroup(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        TestAccessControlList.assertNotNull((Object)th);
        TestAccessControlList.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.removeUser(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        TestAccessControlList.assertNotNull((Object)th);
        TestAccessControlList.assertTrue((boolean)(th instanceof IllegalArgumentException));
        th = null;
        try {
            acl.removeGroup(" * ");
        }
        catch (Throwable t) {
            th = t;
        }
        TestAccessControlList.assertNotNull((Object)th);
        TestAccessControlList.assertTrue((boolean)(th instanceof IllegalArgumentException));
    }

    public void testAddRemoveToWildCardACL() {
        AccessControlList acl = new AccessControlList(" * ");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@APACHE.ORG", (String[])new String[]{"aliens"});
        UserGroupInformation drwho2 = UserGroupInformation.createUserForTesting((String)"drwho2@APACHE.ORG", (String[])new String[]{"tardis"});
        acl.addUser("drwho");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        TestAccessControlList.assertFalse((boolean)acl.getAclString().contains("drwho"));
        acl.addGroup("tardis");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        TestAccessControlList.assertFalse((boolean)acl.getAclString().contains("tardis"));
        acl.removeUser("drwho");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        this.assertUserAllowed(drwho, acl);
        acl.removeGroup("tardis");
        TestAccessControlList.assertTrue((boolean)acl.isAllAllowed());
        this.assertUserAllowed(drwho2, acl);
    }

    public void testIsUserAllowed() {
        UserGroupInformation drwho = UserGroupInformation.createUserForTesting((String)"drwho@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation susan = UserGroupInformation.createUserForTesting((String)"susan@APACHE.ORG", (String[])new String[]{"aliens", "humanoids", "timelord"});
        UserGroupInformation barbara = UserGroupInformation.createUserForTesting((String)"barbara@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        UserGroupInformation ian = UserGroupInformation.createUserForTesting((String)"ian@APACHE.ORG", (String[])new String[]{"humans", "teachers"});
        AccessControlList acl = new AccessControlList("drwho humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho ");
        this.assertUserAllowed(drwho, acl);
        this.assertUserNotAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList(" humanoids");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserNotAllowed(barbara, acl);
        this.assertUserNotAllowed(ian, acl);
        acl = new AccessControlList("drwho,ian aliens,teachers");
        this.assertUserAllowed(drwho, acl);
        this.assertUserAllowed(susan, acl);
        this.assertUserAllowed(barbara, acl);
        this.assertUserAllowed(ian, acl);
    }

    private void assertUserAllowed(UserGroupInformation ugi, AccessControlList acl) {
        TestAccessControlList.assertTrue((String)("User " + ugi + " is not granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }

    private void assertUserNotAllowed(UserGroupInformation ugi, AccessControlList acl) {
        TestAccessControlList.assertFalse((String)("User " + ugi + " is incorrectly granted the access-control!!"), (boolean)acl.isUserAllowed(ugi));
    }
}

