/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSecurityUtil {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void isOriginalTGTReturnsCorrectValues() {
        Assert.assertTrue((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("krbtgt/foo@foo")));
        Assert.assertTrue((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("krbtgt/foo.bar.bat@foo.bar.bat")));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal(null));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("blah")));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal(__PARANAMER_DATA)));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("krbtgt/hello")));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("/@")));
        Assert.assertFalse((boolean)SecurityUtil.isTGSPrincipal((KerberosPrincipal)new KerberosPrincipal("krbtgt/foo@FOO")));
    }

    private void verify(String original, String hostname, String expected) throws IOException {
        Assert.assertEquals((Object)expected, (Object)SecurityUtil.getServerPrincipal((String)original, (String)hostname));
        InetAddress addr = this.mockAddr(hostname);
        Assert.assertEquals((Object)expected, (Object)SecurityUtil.getServerPrincipal((String)original, (InetAddress)addr));
    }

    private InetAddress mockAddr(String reverseTo) {
        InetAddress mock = (InetAddress)Mockito.mock(InetAddress.class);
        ((InetAddress)Mockito.doReturn((Object)reverseTo).when((Object)mock)).getCanonicalHostName();
        return mock;
    }

    @Test
    public void testGetServerPrincipal() throws IOException {
        String service = "hdfs/";
        String realm = "@REALM";
        String hostname = "foohost";
        String userPrincipal = "foo@FOOREALM";
        String shouldReplace = service + "_HOST" + realm;
        String replaced = service + hostname + realm;
        this.verify(shouldReplace, hostname, replaced);
        String shouldNotReplace = service + "_HOST" + "NAME" + realm;
        this.verify(shouldNotReplace, hostname, shouldNotReplace);
        this.verify(userPrincipal, hostname, userPrincipal);
        InetAddress notUsed = (InetAddress)Mockito.mock(InetAddress.class);
        Assert.assertEquals((Object)shouldNotReplace, (Object)SecurityUtil.getServerPrincipal((String)shouldNotReplace, (InetAddress)notUsed));
        ((InetAddress)Mockito.verify((Object)notUsed, (VerificationMode)Mockito.never())).getCanonicalHostName();
    }

    @Test
    public void testLocalHostNameForNullOrWild() throws Exception {
        String local = SecurityUtil.getLocalHostName();
        Assert.assertEquals((Object)("hdfs/" + local + "@REALM"), (Object)SecurityUtil.getServerPrincipal((String)"hdfs/_HOST@REALM", (String)null));
        Assert.assertEquals((Object)("hdfs/" + local + "@REALM"), (Object)SecurityUtil.getServerPrincipal((String)"hdfs/_HOST@REALM", (String)"0.0.0.0"));
    }

    @Test
    public void testStartsWithIncorrectSettings() throws IOException {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        String keyTabKey = "key";
        conf.set(keyTabKey, __PARANAMER_DATA);
        UserGroupInformation.setConfiguration((Configuration)conf);
        boolean gotException = false;
        try {
            SecurityUtil.login((Configuration)conf, (String)keyTabKey, (String)__PARANAMER_DATA, (String)__PARANAMER_DATA);
        }
        catch (IOException e) {
            gotException = true;
        }
        Assert.assertTrue((String)"Exception for empty keytabfile name was expected", (boolean)gotException);
    }
}

