/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.KerberosName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKerberosName {
    public static final String __PARANAMER_DATA = "";

    @Before
    public void setUp() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.auth_to_local", "RULE:[1:$1@$0](.*@YAHOO\\.COM)s/@.*//\nRULE:[2:$1](johndoe)s/^.*$/guest/\nRULE:[2:$1;$2](^.*;admin$)s/;admin$//\nRULE:[2:$2](root)\nDEFAULT");
        conf.set("hadoop.security.authentication", "kerberos");
        KerberosName.setConfiguration((Configuration)conf);
        KerberosName.printRules();
    }

    private void checkTranslation(String from, String to) throws Exception {
        System.out.println("Translate " + from);
        KerberosName nm = new KerberosName(from);
        String simple = nm.getShortName();
        System.out.println("to " + simple);
        Assert.assertEquals((String)"short name incorrect", (Object)to, (Object)simple);
    }

    @Test
    public void testRules() throws Exception {
        this.checkTranslation("omalley@APACHE.ORG", "omalley");
        this.checkTranslation("hdfs/10.0.0.1@APACHE.ORG", "hdfs");
        this.checkTranslation("oom@YAHOO.COM", "oom");
        this.checkTranslation("johndoe/zoo@FOO.COM", "guest");
        this.checkTranslation("joe/admin@FOO.COM", "joe");
        this.checkTranslation("joe/root@FOO.COM", "root");
    }

    private void checkBadName(String name) {
        System.out.println("Checking " + name + " to ensure it is bad.");
        try {
            new KerberosName(name);
            Assert.fail((String)("didn't get exception for " + name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkBadTranslation(String from) {
        System.out.println("Checking bad translation for " + from);
        KerberosName nm = new KerberosName(from);
        try {
            nm.getShortName();
            Assert.fail((String)("didn't get exception for " + from));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testAntiPatterns() throws Exception {
        this.checkBadName("owen/owen/owen@FOO.COM");
        this.checkBadName("owen@foo/bar.com");
        this.checkBadTranslation("foo@ACME.COM");
        this.checkBadTranslation("root/joe@FOO.COM");
    }
}

