/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCredentials {
    private static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA1";
    private static final File tmpDir = new File(System.getProperty("test.build.data", "/tmp"), "mapred");
    public static final String __PARANAMER_DATA = "";

    @Before
    public void setUp() {
        tmpDir.mkdir();
    }

    @After
    public void tearDown() {
        tmpDir.delete();
    }

    @Test
    public <T extends TokenIdentifier> void testReadWriteStorage() throws IOException, NoSuchAlgorithmException {
        Credentials ts = new Credentials();
        Token token1 = new Token();
        Token token2 = new Token();
        Text service1 = new Text("service1");
        Text service2 = new Text("service2");
        ArrayList<Text> services = new ArrayList<Text>();
        services.add(service1);
        services.add(service2);
        token1.setService(service1);
        token2.setService(service2);
        ts.addToken(new Text("sometoken1"), token1);
        ts.addToken(new Text("sometoken2"), token2);
        KeyGenerator kg = KeyGenerator.getInstance(DEFAULT_HMAC_ALGORITHM);
        String alias = "alias";
        HashMap<Text, byte[]> m = new HashMap<Text, byte[]>(10);
        for (int i = 0; i < 10; ++i) {
            SecretKey key = kg.generateKey();
            m.put(new Text(alias + i), key.getEncoded());
            ts.addSecretKey(new Text(alias + i), key.getEncoded());
        }
        File tmpFileName = new File(tmpDir, "tokenStorageTest");
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(tmpFileName));
        ts.write((DataOutput)dos);
        dos.close();
        DataInputStream dis = new DataInputStream(new FileInputStream(tmpFileName));
        ts = new Credentials();
        ts.readFields((DataInput)dis);
        dis.close();
        Collection list = ts.getAllTokens();
        Assert.assertEquals((String)"getAllTokens should return collection of size 2", (long)list.size(), (long)2L);
        boolean foundFirst = false;
        boolean foundSecond = false;
        for (Token token : list) {
            if (token.getService().equals((Object)service1)) {
                foundFirst = true;
            }
            if (!token.getService().equals((Object)service2)) continue;
            foundSecond = true;
        }
        Assert.assertTrue((String)"Tokens for services service1 and service2 must be present", (foundFirst && foundSecond ? 1 : 0) != 0);
        int mapLen = m.size();
        Assert.assertEquals((String)"wrong number of keys in the Storage", (long)mapLen, (long)ts.numberOfSecretKeys());
        for (Text a : m.keySet()) {
            byte[] kTS = ts.getSecretKey(a);
            byte[] kLocal = (byte[])m.get(a);
            Assert.assertTrue((String)("keys don't match for " + a), (WritableComparator.compareBytes((byte[])kTS, (int)0, (int)kTS.length, (byte[])kLocal, (int)0, (int)kLocal.length) == 0 ? 1 : 0) != 0);
        }
        tmpFileName.delete();
    }
}

