/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.record.BinaryRecordInput;
import org.apache.hadoop.record.BinaryRecordOutput;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.RecRecord0;
import org.apache.hadoop.record.RecRecord1;
import org.apache.hadoop.record.RecRecordNew;
import org.apache.hadoop.record.RecRecordOld;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.meta.RecordTypeInfo;

public class TestRecordVersioning
extends TestCase {
    public static final String __PARANAMER_DATA = "<init> java.lang.String testName \n";

    public TestRecordVersioning(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testBasic() {
        try {
            File tmpfile = File.createTempFile("hadooprec", ".dat");
            File tmpRTIfile = File.createTempFile("hadooprti", ".dat");
            FileOutputStream ostream = new FileOutputStream(tmpfile);
            BinaryRecordOutput out = new BinaryRecordOutput((OutputStream)ostream);
            FileOutputStream oRTIstream = new FileOutputStream(tmpRTIfile);
            BinaryRecordOutput outRTI = new BinaryRecordOutput((OutputStream)oRTIstream);
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(-4567);
            r1.setLongVal(-2367L);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            RecRecord0 r0 = new RecRecord0();
            r0.setStringVal("other random text");
            r1.setRecordVal(r0);
            r1.serialize((RecordOutput)out, "");
            ostream.close();
            RecRecord1.getTypeInfo().serialize((RecordOutput)outRTI);
            oRTIstream.close();
            FileInputStream istream = new FileInputStream(tmpfile);
            BinaryRecordInput in = new BinaryRecordInput((InputStream)istream);
            FileInputStream iRTIstream = new FileInputStream(tmpRTIfile);
            BinaryRecordInput inRTI = new BinaryRecordInput((InputStream)iRTIstream);
            RecordTypeInfo rti = new RecordTypeInfo();
            rti.deserialize((RecordInput)inRTI);
            iRTIstream.close();
            RecRecord1.setTypeFilter(rti);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            tmpfile.delete();
            tmpRTIfile.delete();
            TestRecordVersioning.assertTrue((String)"Serialized and deserialized versioned records do not match.", (boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testVersioning() {
        try {
            int l;
            int k;
            int j;
            int i;
            File tmpfile = File.createTempFile("hadooprec", ".dat");
            File tmpRTIfile = File.createTempFile("hadooprti", ".dat");
            FileOutputStream ostream = new FileOutputStream(tmpfile);
            BinaryRecordOutput out = new BinaryRecordOutput((OutputStream)ostream);
            FileOutputStream oRTIstream = new FileOutputStream(tmpRTIfile);
            BinaryRecordOutput outRTI = new BinaryRecordOutput((OutputStream)oRTIstream);
            ArrayList<RecRecordOld> recsWrite = new ArrayList<RecRecordOld>();
            for (i = 0; i < 5; ++i) {
                RecRecordOld s1Rec = new RecRecordOld();
                s1Rec.setName("This is record s1: " + i);
                ArrayList<Long> iA = new ArrayList<Long>();
                for (j = 0; j < 3; ++j) {
                    iA.add(new Long(i + j));
                }
                s1Rec.setIvec(iA);
                ArrayList<ArrayList<RecRecord0>> ssVec = new ArrayList<ArrayList<RecRecord0>>();
                for (j = 0; j < 2; ++j) {
                    ArrayList<RecRecord0> sVec = new ArrayList<RecRecord0>();
                    for (k = 0; k < 3; ++k) {
                        RecRecord0 sRec = new RecRecord0("This is record s: (" + j + ": " + k + ")");
                        sVec.add(sRec);
                    }
                    ssVec.add(sVec);
                }
                s1Rec.setSvec(ssVec);
                s1Rec.setInner(new RecRecord0("This is record s: " + i));
                ArrayList<ArrayList<ArrayList<String>>> aaaVec = new ArrayList<ArrayList<ArrayList<String>>>();
                for (l = 0; l < 2; ++l) {
                    ArrayList aaVec = new ArrayList();
                    for (j = 0; j < 2; ++j) {
                        ArrayList<String> aVec = new ArrayList<String>();
                        for (k = 0; k < 3; ++k) {
                            aVec.add(new String("THis is a nested string: (" + l + ": " + j + ": " + k + ")"));
                        }
                        aaVec.add(aVec);
                    }
                    aaaVec.add(aaVec);
                }
                s1Rec.setStrvec(aaaVec);
                s1Rec.setI1(100 + i);
                TreeMap<Byte, String> map1 = new TreeMap<Byte, String>();
                map1.put(new Byte("23"), "23");
                map1.put(new Byte("11"), "11");
                s1Rec.setMap1(map1);
                TreeMap<Integer, Long> m1 = new TreeMap<Integer, Long>();
                TreeMap<Integer, Long> m2 = new TreeMap<Integer, Long>();
                m1.put(new Integer(5), 5L);
                m1.put(new Integer(10), 10L);
                m2.put(new Integer(15), 15L);
                m2.put(new Integer(20), 20L);
                ArrayList<TreeMap<Integer, Long>> vm1 = new ArrayList<TreeMap<Integer, Long>>();
                vm1.add(m1);
                vm1.add(m2);
                s1Rec.setMvec1(vm1);
                ArrayList<TreeMap<Integer, Long>> vm2 = new ArrayList<TreeMap<Integer, Long>>();
                vm2.add(m1);
                s1Rec.setMvec2(vm2);
                recsWrite.add(s1Rec);
            }
            for (RecRecordOld rec : recsWrite) {
                rec.serialize((RecordOutput)out);
            }
            ostream.close();
            RecRecordOld.getTypeInfo().serialize((RecordOutput)outRTI);
            oRTIstream.close();
            FileInputStream istream = new FileInputStream(tmpfile);
            BinaryRecordInput in = new BinaryRecordInput((InputStream)istream);
            FileInputStream iRTIstream = new FileInputStream(tmpRTIfile);
            BinaryRecordInput inRTI = new BinaryRecordInput((InputStream)iRTIstream);
            RecordTypeInfo rti = new RecordTypeInfo();
            rti.deserialize((RecordInput)inRTI);
            iRTIstream.close();
            RecRecordNew.setTypeFilter(rti);
            ArrayList<RecRecordNew> recsRead = new ArrayList<RecRecordNew>();
            for (i = 0; i < recsWrite.size(); ++i) {
                RecRecordNew s2Rec = new RecRecordNew();
                s2Rec.deserialize((RecordInput)in);
                recsRead.add(s2Rec);
            }
            istream.close();
            tmpfile.delete();
            tmpRTIfile.delete();
            for (i = 0; i < recsRead.size(); ++i) {
                RecRecordOld s1Out = (RecRecordOld)((Object)recsWrite.get(i));
                RecRecordNew s2In = (RecRecordNew)((Object)recsRead.get(i));
                TestRecordVersioning.assertTrue((String)"Incorrectly read name2 field", (null == s2In.getName2() ? 1 : 0) != 0);
                TestRecordVersioning.assertTrue((String)"Error comparing inner fields", (0 == s1Out.getInner().compareTo((Object)s2In.getInner()) ? 1 : 0) != 0);
                TestRecordVersioning.assertTrue((String)"Incorrectly read ivec field", (null == s2In.getIvec() ? 1 : 0) != 0);
                TestRecordVersioning.assertTrue((String)"Incorrectly read svec field", (null == s2In.getSvec() ? 1 : 0) != 0);
                for (j = 0; j < s2In.getStrvec().size(); ++j) {
                    ArrayList<ArrayList<String>> ss2Vec = s2In.getStrvec().get(j);
                    ArrayList<ArrayList<String>> ss1Vec = s1Out.getStrvec().get(j);
                    for (k = 0; k < ss2Vec.size(); ++k) {
                        ArrayList<String> s2Vec = ss2Vec.get(k);
                        ArrayList<String> s1Vec = ss1Vec.get(k);
                        for (l = 0; l < s2Vec.size(); ++l) {
                            TestRecordVersioning.assertTrue((String)"Error comparing strVec fields", (0 == s2Vec.get(l).compareTo(s1Vec.get(l)) ? 1 : 0) != 0);
                        }
                    }
                }
                TestRecordVersioning.assertTrue((String)"Incorrectly read map1 field", (null == s2In.getMap1() ? 1 : 0) != 0);
                for (j = 0; j < s2In.getMvec2().size(); ++j) {
                    TestRecordVersioning.assertTrue((String)"Error comparing mvec2 fields", (boolean)s2In.getMvec2().get(j).equals(s1Out.getMvec2().get(j)));
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

