/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.record.BinaryRecordInput;
import org.apache.hadoop.record.BinaryRecordOutput;
import org.apache.hadoop.record.Buffer;
import org.apache.hadoop.record.CsvRecordInput;
import org.apache.hadoop.record.CsvRecordOutput;
import org.apache.hadoop.record.RecRecord0;
import org.apache.hadoop.record.RecRecord1;
import org.apache.hadoop.record.RecordInput;
import org.apache.hadoop.record.RecordOutput;
import org.apache.hadoop.record.XmlRecordInput;
import org.apache.hadoop.record.XmlRecordOutput;

public class TestRecordIO
extends TestCase {
    public static final String __PARANAMER_DATA = "<init> java.lang.String testName \n";

    public TestRecordIO(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void testBinary() {
        try {
            File tmpfile = File.createTempFile("hadooprec", ".dat");
            FileOutputStream ostream = new FileOutputStream(tmpfile);
            BinaryRecordOutput out = new BinaryRecordOutput((OutputStream)ostream);
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(-4567);
            r1.setLongVal(-2367L);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            RecRecord0 r0 = new RecRecord0();
            r0.setStringVal("other random text");
            r1.setRecordVal(r0);
            r1.serialize((RecordOutput)out, "");
            ostream.close();
            FileInputStream istream = new FileInputStream(tmpfile);
            BinaryRecordInput in = new BinaryRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            tmpfile.delete();
            TestRecordIO.assertTrue((String)"Serialized and deserialized records do not match.", (boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testCsv() {
        try {
            File tmpfile = File.createTempFile("hadooprec", ".txt");
            FileOutputStream ostream = new FileOutputStream(tmpfile);
            CsvRecordOutput out = new CsvRecordOutput((OutputStream)ostream);
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("random text");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            RecRecord0 r0 = new RecRecord0();
            r0.setStringVal("other random text");
            r1.setRecordVal(r0);
            r1.serialize((RecordOutput)out, "");
            ostream.close();
            FileInputStream istream = new FileInputStream(tmpfile);
            CsvRecordInput in = new CsvRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            tmpfile.delete();
            TestRecordIO.assertTrue((String)"Serialized and deserialized records do not match.", (boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testToString() {
        try {
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("random text");
            byte[] barr = new byte[256];
            for (int idx = 0; idx < 256; ++idx) {
                barr[idx] = (byte)idx;
            }
            r1.setBufferVal(new Buffer(barr));
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            RecRecord0 r0 = new RecRecord0();
            r0.setStringVal("other random text");
            r1.setRecordVal(r0);
            System.err.println("Illustrating toString bug" + r1.toString());
            System.err.println("Illustrating toString bug" + r1.toString());
        }
        catch (Throwable ex) {
            TestRecordIO.assertTrue((String)"Record.toString cannot be invoked twice in succession.This bug has been fixed in the latest version.", (boolean)false);
        }
    }

    public void testXml() {
        try {
            File tmpfile = File.createTempFile("hadooprec", ".xml");
            FileOutputStream ostream = new FileOutputStream(tmpfile);
            XmlRecordOutput out = new XmlRecordOutput((OutputStream)ostream);
            RecRecord1 r1 = new RecRecord1();
            r1.setBoolVal(true);
            r1.setByteVal((byte)102);
            r1.setFloatVal(3.145f);
            r1.setDoubleVal(1.5234);
            r1.setIntVal(4567);
            r1.setLongVal(0x5A5A5A5A5A5AL);
            r1.setStringVal("ran\u0002dom &lt; %text<&more\uffff");
            r1.setBufferVal(new Buffer());
            r1.setVectorVal(new ArrayList<String>());
            r1.setMapVal(new TreeMap<String, String>());
            RecRecord0 r0 = new RecRecord0();
            r0.setStringVal("other %rando\u0007m &amp; >&more text");
            r1.setRecordVal(r0);
            r1.serialize((RecordOutput)out, "");
            ostream.close();
            FileInputStream istream = new FileInputStream(tmpfile);
            XmlRecordInput in = new XmlRecordInput((InputStream)istream);
            RecRecord1 r2 = new RecRecord1();
            r2.deserialize((RecordInput)in, "");
            istream.close();
            tmpfile.delete();
            TestRecordIO.assertTrue((String)"Serialized and deserialized records do not match.", (boolean)r1.equals((Object)r2));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void testCloneable() {
        RecRecord1 r1 = new RecRecord1();
        r1.setBoolVal(true);
        r1.setByteVal((byte)102);
        r1.setFloatVal(3.145f);
        r1.setDoubleVal(1.5234);
        r1.setIntVal(-4567);
        r1.setLongVal(-2367L);
        r1.setStringVal("random text");
        r1.setBufferVal(new Buffer());
        r1.setVectorVal(new ArrayList<String>());
        r1.setMapVal(new TreeMap<String, String>());
        RecRecord0 r0 = new RecRecord0();
        r0.setStringVal("other random text");
        r1.setRecordVal(r0);
        try {
            RecRecord1 r2 = (RecRecord1)((Object)r1.clone());
            TestRecordIO.assertTrue((String)"Cloneable semantics violated. r1==r2", (r1 != r2 ? 1 : 0) != 0);
            TestRecordIO.assertTrue((String)"Cloneable semantics violated. r1.getClass() != r2.getClass()", (((Object)((Object)r1)).getClass() == ((Object)((Object)r2)).getClass() ? 1 : 0) != 0);
            TestRecordIO.assertTrue((String)"Cloneable semantics violated. !r2.equals(r1)", (boolean)r2.equals((Object)r1));
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
    }
}

