/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.SocketInputStream;
import org.apache.hadoop.net.SocketOutputStream;

public class TestSocketIOWithTimeout
extends TestCase {
    static Log LOG = LogFactory.getLog(TestSocketIOWithTimeout.class);
    private static int TIMEOUT = 1000;
    private static String TEST_STRING = "1234567890";
    public static final String __PARANAMER_DATA = "";

    private void doIO(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[4192];
        while (true) {
            long start = System.currentTimeMillis();
            try {
                if (in != null) {
                    in.read(buf);
                    continue;
                }
                out.write(buf);
            }
            catch (SocketTimeoutException e) {
                long diff = System.currentTimeMillis() - start;
                LOG.info((Object)("Got SocketTimeoutException as expected after " + diff + " millis : " + e.getMessage()));
                TestSocketIOWithTimeout.assertTrue((Math.abs((long)TIMEOUT - diff) <= 200L ? 1 : 0) != 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSocketIOWithTimeout() throws IOException {
        Pipe pipe = Pipe.open();
        Pipe.SourceChannel source = pipe.source();
        Pipe.SinkChannel sink = pipe.sink();
        try {
            SocketInputStream in = new SocketInputStream((ReadableByteChannel)source, (long)TIMEOUT);
            SocketOutputStream out = new SocketOutputStream((WritableByteChannel)sink, (long)TIMEOUT);
            byte[] writeBytes = TEST_STRING.getBytes();
            byte[] readBytes = new byte[writeBytes.length];
            int byteWithHighBit = -128;
            out.write(writeBytes);
            out.write(byteWithHighBit);
            this.doIO(null, (OutputStream)out);
            in.read(readBytes);
            TestSocketIOWithTimeout.assertTrue((boolean)Arrays.equals(writeBytes, readBytes));
            TestSocketIOWithTimeout.assertEquals((int)(byteWithHighBit & 0xFF), (int)in.read());
            this.doIO((InputStream)in, null);
            in = new SocketInputStream((ReadableByteChannel)source, 0L);
            Thread thread = new Thread(new ReadRunnable((InputStream)in));
            thread.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new IOException("Unexpected InterruptedException : " + e);
            }
            TestSocketIOWithTimeout.assertTrue((boolean)source.isOpen());
            TestSocketIOWithTimeout.assertTrue((boolean)sink.isOpen());
            out.close();
            TestSocketIOWithTimeout.assertFalse((boolean)sink.isOpen());
            TestSocketIOWithTimeout.assertEquals((int)-1, (int)in.read());
            in.close();
            TestSocketIOWithTimeout.assertFalse((boolean)source.isOpen());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sink != null) {
                sink.close();
            }
        }
    }

    static class ReadRunnable
    implements Runnable {
        private InputStream in;
        public static final String __PARANAMER_DATA = "<init> java.io.InputStream in \n";

        public ReadRunnable(InputStream in) {
            this.in = in;
        }

        @Override
        public void run() {
            try {
                this.in.read();
            }
            catch (IOException e) {
                LOG.info((Object)("Got expection while reading as expected : " + e.getMessage()));
                return;
            }
            Assert.assertTrue((boolean)false);
        }
    }
}

