/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestNetUtils {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testAvoidLoopbackTcpSockets() throws Exception {
        Configuration conf = new Configuration();
        Socket socket = NetUtils.getDefaultSocketFactory((Configuration)conf).createSocket();
        socket.bind(new InetSocketAddress("127.0.0.1", 0));
        System.err.println("local address: " + socket.getLocalAddress());
        System.err.println("local port: " + socket.getLocalPort());
        try {
            NetUtils.connect((Socket)socket, (SocketAddress)new InetSocketAddress(socket.getLocalAddress(), socket.getLocalPort()), (int)20000);
            socket.close();
            Assert.fail((String)"Should not have connected");
        }
        catch (ConnectException ce) {
            System.err.println("Got exception: " + ce);
            Assert.assertTrue((boolean)ce.getMessage().contains("resulted in a loopback"));
        }
        catch (SocketException se) {
            Assert.assertTrue((boolean)se.getMessage().contains("Invalid argument"));
        }
    }
}

