/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.net.DNSToSwitchMapping;

public class StaticMapping
extends Configured
implements DNSToSwitchMapping {
    private static Map<String, String> nameToRackMap = new HashMap<String, String>();
    public static final String __PARANAMER_DATA = "resolve java.util.List names \naddNodeToRack java.lang.String,java.lang.String name,rackId \nsetconf org.apache.hadoop.conf.Configuration conf \n";

    public void setconf(Configuration conf) {
        String[] mappings = conf.getStrings("hadoop.configured.node.mapping");
        if (mappings != null) {
            for (int i = 0; i < mappings.length; ++i) {
                String str = mappings[i];
                String host = str.substring(0, str.indexOf(61));
                String rack = str.substring(str.indexOf(61) + 1);
                StaticMapping.addNodeToRack(host, rack);
            }
        }
    }

    public static synchronized void addNodeToRack(String name, String rackId) {
        nameToRackMap.put(name, rackId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> resolve(List<String> names) {
        ArrayList<String> m = new ArrayList<String>();
        Map<String, String> map = nameToRackMap;
        synchronized (map) {
            for (String name : names) {
                String rackId = nameToRackMap.get(name);
                if (rackId != null) {
                    m.add(rackId);
                    continue;
                }
                m.add("/default-rack");
            }
            return m;
        }
    }
}

