/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.log;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.log.LogLevel;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TestLogLevel
extends TestCase {
    static final PrintStream out = System.out;
    public static final String __PARANAMER_DATA = "";

    public void testDynamicLogLevel() throws Exception {
        String logName = TestLogLevel.class.getName();
        Log testlog = LogFactory.getLog((String)logName);
        if (testlog instanceof Log4JLogger) {
            String line;
            Logger log = ((Log4JLogger)testlog).getLogger();
            log.debug((Object)"log.debug1");
            log.info((Object)"log.info1");
            log.error((Object)"log.error1");
            TestLogLevel.assertTrue((!Level.ERROR.equals((Object)log.getEffectiveLevel()) ? 1 : 0) != 0);
            HttpServer server = new HttpServer("..", "localhost", 22222, true);
            server.start();
            int port = server.getPort();
            URL url = new URL("http://localhost:" + port + "/logLevel?log=" + logName + "&level=" + Level.ERROR);
            out.println("*** Connecting to " + url);
            URLConnection connection = url.openConnection();
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
            in.close();
            log.debug((Object)"log.debug2");
            log.info((Object)"log.info2");
            log.error((Object)"log.error2");
            TestLogLevel.assertTrue((boolean)Level.ERROR.equals((Object)log.getEffectiveLevel()));
            String[] args = new String[]{"-setlevel", "localhost:" + port, logName, __PARANAMER_DATA + Level.DEBUG};
            LogLevel.main((String[])args);
            log.debug((Object)"log.debug3");
            log.info((Object)"log.info3");
            log.error((Object)"log.error3");
            TestLogLevel.assertTrue((boolean)Level.DEBUG.equals((Object)log.getEffectiveLevel()));
        } else {
            out.println(testlog.getClass() + " not tested.");
        }
    }
}

