/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.net.InetSocketAddress;
import junit.framework.TestCase;
import org.apache.avro.AvroRemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.AvroRpcEngine;
import org.apache.hadoop.ipc.AvroSpecificRpcEngine;
import org.apache.hadoop.ipc.AvroSpecificTestProtocol;
import org.apache.hadoop.ipc.AvroTestProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;

public class TestAvroRpc
extends TestCase {
    private static final String ADDRESS = "0.0.0.0";
    public static final Log LOG = LogFactory.getLog(TestAvroRpc.class);
    private static Configuration conf = new Configuration();
    int datasize = 102400;
    int numThreads = 50;
    public static final String __PARANAMER_DATA = "<init> java.lang.String name \n";

    public TestAvroRpc(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCalls() throws Exception {
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, AvroTestProtocol.class, AvroRpcEngine.class);
        RPC.Server server = RPC.getServer(AvroTestProtocol.class, (Object)new TestImpl(), (String)ADDRESS, (int)0, (Configuration)conf);
        AvroTestProtocol proxy = null;
        try {
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            proxy = (AvroTestProtocol)RPC.getProxy(AvroTestProtocol.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
            proxy.ping();
            String echo = proxy.echo("hello world");
            TestAvroRpc.assertEquals((String)"hello world", (String)echo);
            int intResult = proxy.add(1, 2);
            TestAvroRpc.assertEquals((int)3, (int)intResult);
            boolean caught = false;
            try {
                proxy.error();
            }
            catch (AvroRemoteException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Caught " + (Object)((Object)e)));
                }
                caught = true;
            }
            TestAvroRpc.assertTrue((boolean)caught);
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAvroSpecificRpc() throws Exception {
        Configuration conf = new Configuration();
        RPC.setProtocolEngine((Configuration)conf, AvroSpecificTestProtocol.class, AvroSpecificRpcEngine.class);
        RPC.Server server = RPC.getServer(AvroSpecificTestProtocol.class, (Object)new AvroSpecificTestProtocolImpl(), (String)ADDRESS, (int)0, (Configuration)conf);
        AvroSpecificTestProtocol proxy = null;
        try {
            server.start();
            InetSocketAddress addr = NetUtils.getConnectAddress((Server)server);
            proxy = (AvroSpecificTestProtocol)RPC.getProxy(AvroSpecificTestProtocol.class, (long)0L, (InetSocketAddress)addr, (Configuration)conf);
            CharSequence echo = proxy.echo("hello world");
            TestAvroRpc.assertEquals((String)"hello world", (String)((Object)echo).toString());
            int intResult = proxy.add(1, 2);
            TestAvroRpc.assertEquals((int)3, (int)intResult);
        }
        finally {
            server.stop();
        }
    }

    public static class AvroSpecificTestProtocolImpl
    implements AvroSpecificTestProtocol {
        public static final String __PARANAMER_DATA = "add int,int arg1,arg2 \necho java.lang.CharSequence msg \n";

        @Override
        public int add(int arg1, int arg2) throws AvroRemoteException {
            return arg1 + arg2;
        }

        @Override
        public CharSequence echo(CharSequence msg) throws AvroRemoteException {
            return msg;
        }
    }

    public static class TestImpl
    implements AvroTestProtocol {
        public static final String __PARANAMER_DATA = "add int,int v1,v2 \necho java.lang.String value \n";

        @Override
        public void ping() {
        }

        @Override
        public String echo(String value) {
            return value;
        }

        @Override
        public int add(int v1, int v2) {
            return v1 + v2;
        }

        @Override
        public int error() throws AvroTestProtocol.Problem {
            throw new AvroTestProtocol.Problem();
        }
    }
}

