/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.nativeio;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.Errno;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.NativeCodeLoader;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestNativeIO {
    static final Log LOG = LogFactory.getLog(TestNativeIO.class);
    static final File TEST_DIR = new File(System.getProperty("test.build.data"), "testnativeio");
    public static final String __PARANAMER_DATA = "";

    @Before
    public void checkLoaded() {
        Assume.assumeTrue((boolean)NativeCodeLoader.isNativeCodeLoaded());
    }

    @Before
    public void setupTestDir() throws IOException {
        FileUtil.fullyDelete((File)TEST_DIR);
        TEST_DIR.mkdirs();
    }

    @Test
    public void testFstat() throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat"));
        NativeIO.Stat stat = NativeIO.fstat((FileDescriptor)fos.getFD());
        fos.close();
        LOG.info((Object)("Stat: " + String.valueOf(stat)));
        Assert.assertEquals((Object)System.getProperty("user.name"), (Object)stat.getOwner());
        Assert.assertNotNull((Object)stat.getGroup());
        Assert.assertTrue((!__PARANAMER_DATA.equals(stat.getGroup()) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Stat mode field should indicate a regular file", (long)32768L, (long)(stat.getMode() & 0xF000));
    }

    @Test
    public void testMultiThreadedFstat() throws Exception {
        final FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat"));
        final AtomicReference thrown = new AtomicReference();
        ArrayList<1> statters = new ArrayList<1>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    long et = System.currentTimeMillis() + 5000L;
                    while (System.currentTimeMillis() < et) {
                        try {
                            NativeIO.Stat stat = NativeIO.fstat((FileDescriptor)fos.getFD());
                            Assert.assertEquals((Object)System.getProperty("user.name"), (Object)stat.getOwner());
                            Assert.assertNotNull((Object)stat.getGroup());
                            Assert.assertTrue((!TestNativeIO.__PARANAMER_DATA.equals(stat.getGroup()) ? 1 : 0) != 0);
                            Assert.assertEquals((String)"Stat mode field should indicate a regular file", (long)32768L, (long)(stat.getMode() & 0xF000));
                        }
                        catch (Throwable t) {
                            thrown.set(t);
                        }
                    }
                }
            };
            statters.add(thread);
            thread.start();
        }
        for (Thread thread : statters) {
            thread.join();
        }
        fos.close();
        if (thrown.get() != null) {
            throw new RuntimeException((Throwable)thrown.get());
        }
    }

    @Test
    public void testFstatClosedFd() throws Exception {
        FileOutputStream fos = new FileOutputStream(new File(TEST_DIR, "testfstat2"));
        fos.close();
        try {
            NativeIO.Stat stat = NativeIO.fstat((FileDescriptor)fos.getFD());
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.EBADF, (Object)nioe.getErrno());
        }
    }

    @Test
    public void testOpenMissingWithoutCreate() throws Exception {
        LOG.info((Object)"Open a missing file without O_CREAT and it should fail");
        try {
            FileDescriptor fd = NativeIO.open((String)new File(TEST_DIR, "doesntexist").getAbsolutePath(), (int)1, (int)448);
            Assert.fail((String)"Able to open a new file without O_CREAT");
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.ENOENT, (Object)nioe.getErrno());
        }
    }

    @Test
    public void testOpenWithCreate() throws Exception {
        LOG.info((Object)"Test creating a file with O_CREAT");
        FileDescriptor fd = NativeIO.open((String)new File(TEST_DIR, "testWorkingOpen").getAbsolutePath(), (int)65, (int)448);
        Assert.assertNotNull((Object)true);
        Assert.assertTrue((boolean)fd.valid());
        FileOutputStream fos = new FileOutputStream(fd);
        fos.write("foo".getBytes());
        fos.close();
        Assert.assertFalse((boolean)fd.valid());
        LOG.info((Object)"Test exclusive create");
        try {
            fd = NativeIO.open((String)new File(TEST_DIR, "testWorkingOpen").getAbsolutePath(), (int)193, (int)448);
            Assert.fail((String)"Was able to create existing file with O_EXCL");
        }
        catch (NativeIOException nioe) {
            LOG.info((Object)"Got expected exception for failed exclusive create", (Throwable)nioe);
            Assert.assertEquals((Object)Errno.EEXIST, (Object)nioe.getErrno());
        }
    }

    @Test
    public void testFDDoesntLeak() throws IOException {
        for (int i = 0; i < 10000; ++i) {
            FileDescriptor fd = NativeIO.open((String)new File(TEST_DIR, "testNoFdLeak").getAbsolutePath(), (int)65, (int)448);
            Assert.assertNotNull((Object)true);
            Assert.assertTrue((boolean)fd.valid());
            FileOutputStream fos = new FileOutputStream(fd);
            fos.write("foo".getBytes());
            fos.close();
        }
    }

    @Test
    public void testChmod() throws Exception {
        try {
            NativeIO.chmod((String)"/this/file/doesnt/exist", (int)777);
            Assert.fail((String)"Chmod of non-existent file didn't fail");
        }
        catch (NativeIOException nioe) {
            Assert.assertEquals((Object)Errno.ENOENT, (Object)nioe.getErrno());
        }
        File toChmod = new File(TEST_DIR, "testChmod");
        Assert.assertTrue((String)"Create test subject", (toChmod.exists() || toChmod.mkdir() ? 1 : 0) != 0);
        NativeIO.chmod((String)toChmod.getAbsolutePath(), (int)511);
        this.assertPermissions(toChmod, 511);
        NativeIO.chmod((String)toChmod.getAbsolutePath(), (int)0);
        this.assertPermissions(toChmod, 0);
        NativeIO.chmod((String)toChmod.getAbsolutePath(), (int)420);
        this.assertPermissions(toChmod, 420);
    }

    private void assertPermissions(File f, int expected) throws IOException {
        LocalFileSystem localfs = FileSystem.getLocal((Configuration)new Configuration());
        FsPermission perms = localfs.getFileStatus(new Path(f.getAbsolutePath())).getPermission();
        Assert.assertEquals((long)expected, (long)perms.toShort());
    }
}

