/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;

public class TestTFileSeqFileComparison
extends TestCase {
    MyOptions options;
    private FileSystem fs;
    private Configuration conf;
    private long startTimeEpoch;
    private long finishTimeEpoch;
    private DateFormat formatter;
    byte[][] dictionary;
    public static final String __PARANAMER_DATA = "formatTime long milis \nmain java.lang.String[] args \nprintlnWithTimestamp java.lang.String message \n";

    public void setUp() throws IOException {
        if (this.options == null) {
            this.options = new MyOptions(new String[0]);
        }
        this.conf = new Configuration();
        this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSize);
        this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSize);
        Path path = new Path(this.options.rootDir);
        this.fs = path.getFileSystem(this.conf);
        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.setUpDictionary();
    }

    private void setUpDictionary() {
        Random rng = new Random();
        this.dictionary = new byte[this.options.dictSize][];
        for (int i = 0; i < this.options.dictSize; ++i) {
            int len = rng.nextInt(this.options.maxWordLen - this.options.minWordLen) + this.options.minWordLen;
            this.dictionary[i] = new byte[len];
            rng.nextBytes(this.dictionary[i]);
        }
    }

    public void tearDown() throws IOException {
    }

    public void startTime() throws IOException {
        this.startTimeEpoch = System.currentTimeMillis();
        System.out.println(this.formatTime() + " Started timing.");
    }

    public void stopTime() throws IOException {
        this.finishTimeEpoch = System.currentTimeMillis();
        System.out.println(this.formatTime() + " Stopped timing.");
    }

    public long getIntervalMillis() throws IOException {
        return this.finishTimeEpoch - this.startTimeEpoch;
    }

    public void printlnWithTimestamp(String message) throws IOException {
        System.out.println(this.formatTime() + "  " + message);
    }

    public String formatTime(long milis) {
        return this.formatter.format(milis);
    }

    public String formatTime() {
        return this.formatTime(System.currentTimeMillis());
    }

    private void reportStats(Path path, long totalBytes) throws IOException {
        long duration = this.getIntervalMillis();
        long fsize = this.fs.getFileStatus(path).getLen();
        this.printlnWithTimestamp(String.format("Duration: %dms...total size: %.2fMB...raw thrpt: %.2fMB/s", duration, (double)totalBytes / 1024.0 / 1024.0, (double)totalBytes / (double)duration * 1000.0 / 1024.0 / 1024.0));
        this.printlnWithTimestamp(String.format("Compressed size: %.2fMB...compressed thrpt: %.2fMB/s.", (double)fsize / 1024.0 / 1024.0, (double)fsize / (double)duration * 1000.0 / 1024.0 / 1024.0));
    }

    private void fillBuffer(Random rng, BytesWritable bw, byte[] tmp, int len) {
        int l;
        for (int n = 0; n < len; n += l) {
            byte[] word = this.dictionary[rng.nextInt(this.dictionary.length)];
            l = Math.min(word.length, len - n);
            System.arraycopy(word, 0, tmp, n, l);
        }
        bw.set(tmp, 0, len);
    }

    private void timeWrite(Path path, KVAppendable appendable, int baseKlen, int baseVlen, long fileSize) throws IOException {
        int maxKlen = baseKlen * 2;
        int maxVlen = baseVlen * 2;
        BytesWritable key = new BytesWritable();
        BytesWritable value = new BytesWritable();
        byte[] keyBuffer = new byte[maxKlen];
        byte[] valueBuffer = new byte[maxVlen];
        Random rng = new Random(this.options.seed);
        long totalBytes = 0L;
        this.printlnWithTimestamp("Start writing: " + path.getName() + "...");
        this.startTime();
        long i = 0L;
        while (i % 1000L != 0L || this.fs.getFileStatus(path).getLen() < fileSize) {
            int klen = rng.nextInt(baseKlen) + baseKlen;
            int vlen = rng.nextInt(baseVlen) + baseVlen;
            this.fillBuffer(rng, key, keyBuffer, klen);
            this.fillBuffer(rng, value, valueBuffer, vlen);
            key.set(keyBuffer, 0, klen);
            value.set(valueBuffer, 0, vlen);
            appendable.append(key, value);
            totalBytes += (long)klen;
            totalBytes += (long)vlen;
            ++i;
        }
        this.stopTime();
        appendable.close();
        this.reportStats(path, totalBytes);
    }

    private void timeRead(Path path, KVReadable readable) throws IOException {
        this.printlnWithTimestamp("Start reading: " + path.getName() + "...");
        long totalBytes = 0L;
        this.startTime();
        while (readable.next()) {
            totalBytes += (long)readable.getKeyLength();
            totalBytes += (long)readable.getValueLength();
        }
        this.stopTime();
        readable.close();
        this.reportStats(path, totalBytes);
    }

    private void createTFile(String parameters, String compress) throws IOException {
        System.out.println("=== TFile: Creation (" + parameters + ") === ");
        Path path = new Path(this.options.rootDir, "TFile.Performance");
        TFileAppendable appendable = new TFileAppendable(this.fs, path, compress, this.options.minBlockSize, this.options.osOutputBufferSize, this.conf);
        this.timeWrite(path, appendable, this.options.keyLength, this.options.valueLength, this.options.fileSize);
    }

    private void readTFile(String parameters, boolean delFile) throws IOException {
        System.out.println("=== TFile: Reading (" + parameters + ") === ");
        Path path = new Path(this.options.rootDir, "TFile.Performance");
        TFileReadable readable = new TFileReadable(this.fs, path, this.options.osInputBufferSize, this.conf);
        this.timeRead(path, readable);
        if (delFile && this.fs.exists(path)) {
            this.fs.delete(path, true);
        }
    }

    private void createSeqFile(String parameters, String compress) throws IOException {
        System.out.println("=== SeqFile: Creation (" + parameters + ") === ");
        Path path = new Path(this.options.rootDir, "SeqFile.Performance");
        SeqFileAppendable appendable = new SeqFileAppendable(this.fs, path, this.options.osOutputBufferSize, compress, this.options.minBlockSize);
        this.timeWrite(path, appendable, this.options.keyLength, this.options.valueLength, this.options.fileSize);
    }

    private void readSeqFile(String parameters, boolean delFile) throws IOException {
        System.out.println("=== SeqFile: Reading (" + parameters + ") === ");
        Path path = new Path(this.options.rootDir, "SeqFile.Performance");
        SeqFileReadable readable = new SeqFileReadable(this.fs, path, this.options.osInputBufferSize);
        this.timeRead(path, readable);
        if (delFile && this.fs.exists(path)) {
            this.fs.delete(path, true);
        }
    }

    private void compareRun(String compress) throws IOException {
        String[] supported = TFile.getSupportedCompressionAlgorithms();
        boolean proceed = false;
        for (String c : supported) {
            if (!c.equals(compress)) continue;
            proceed = true;
            break;
        }
        if (!proceed) {
            System.out.println("Skipped for " + compress);
            return;
        }
        this.options.compress = compress;
        String parameters = TestTFileSeqFileComparison.parameters2String(this.options);
        this.createSeqFile(parameters, compress);
        this.readSeqFile(parameters, true);
        this.createTFile(parameters, compress);
        this.readTFile(parameters, true);
        this.createTFile(parameters, compress);
        this.readTFile(parameters, true);
        this.createSeqFile(parameters, compress);
        this.readSeqFile(parameters, true);
    }

    public void testRunComparisons() throws IOException {
        String[] compresses;
        for (String compress : compresses = new String[]{"none", "lzo", "gz"}) {
            if (compress.equals("none")) {
                this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSizeNone);
                this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSizeNone);
            } else if (compress.equals("lzo")) {
                this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSizeLzo);
                this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSizeLzo);
            } else {
                this.conf.setInt("tfile.fs.input.buffer.size", this.options.fsInputBufferSizeGz);
                this.conf.setInt("tfile.fs.output.buffer.size", this.options.fsOutputBufferSizeGz);
            }
            this.compareRun(compress);
        }
    }

    private static String parameters2String(MyOptions options) {
        return String.format("KLEN: %d-%d... VLEN: %d-%d...MinBlkSize: %.2fKB...Target Size: %.2fMB...Compression: ...%s", options.keyLength, options.keyLength * 2, options.valueLength, options.valueLength * 2, (double)options.minBlockSize / 1024.0, (double)options.fileSize / 1024.0 / 1024.0, options.compress);
    }

    public static void main(String[] args) throws IOException {
        TestTFileSeqFileComparison testCase = new TestTFileSeqFileComparison();
        MyOptions options = new MyOptions(args);
        if (!options.proceed) {
            return;
        }
        testCase.options = options;
        String parameters = TestTFileSeqFileComparison.parameters2String(options);
        testCase.setUp();
        if (testCase.options.format.equals("tfile")) {
            if (options.doCreate()) {
                testCase.createTFile(parameters, options.compress);
            }
            if (options.doRead()) {
                testCase.readTFile(parameters, options.doCreate());
            }
        } else {
            if (options.doCreate()) {
                testCase.createSeqFile(parameters, options.compress);
            }
            if (options.doRead()) {
                testCase.readSeqFile(parameters, options.doCreate());
            }
        }
        testCase.tearDown();
    }

    private static class MyOptions {
        String rootDir = System.getProperty("test.build.data", "/tmp/tfile-test");
        String compress = "gz";
        String format = "tfile";
        int dictSize = 1000;
        int minWordLen = 5;
        int maxWordLen = 20;
        int keyLength = 50;
        int valueLength = 100;
        int minBlockSize = 262144;
        int fsOutputBufferSize = 1;
        int fsInputBufferSize = 0;
        int fsInputBufferSizeNone = 0;
        int fsInputBufferSizeGz = 0;
        int fsInputBufferSizeLzo = 0;
        int fsOutputBufferSizeNone = 1;
        int fsOutputBufferSizeGz = 1;
        int fsOutputBufferSizeLzo = 1;
        int osInputBufferSize = 65536;
        int osOutputBufferSize = 65536;
        long fileSize = 0x300000L;
        long seed = System.nanoTime();
        static final int OP_CREATE = 1;
        static final int OP_READ = 2;
        int op = 2;
        boolean proceed = false;
        public static final String __PARANAMER_DATA = "<init> java.lang.String[] args \n";

        public MyOptions(String[] args) {
            try {
                Options opts = this.buildOptions();
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(opts, args, true);
                this.processOptions(line, opts);
                this.validateOptions();
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
                System.out.println("Try \"--help\" option for details.");
                this.setStopProceed();
            }
        }

        public boolean proceed() {
            return this.proceed;
        }

        private Options buildOptions() {
            OptionBuilder.withLongOpt((String)"compress");
            OptionBuilder.withArgName((String)"[none|lzo|gz]");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"compression scheme");
            Option compress = OptionBuilder.create((char)'c');
            OptionBuilder.withLongOpt((String)"dict");
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"number of dictionary entries");
            Option ditSize = OptionBuilder.create((char)'d');
            OptionBuilder.withLongOpt((String)"file-size");
            OptionBuilder.withArgName((String)"size-in-MB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"target size of the file (in MB).");
            Option fileSize = OptionBuilder.create((char)'s');
            OptionBuilder.withLongOpt((String)"format");
            OptionBuilder.withArgName((String)"[tfile|seqfile]");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"choose TFile or SeqFile");
            Option format = OptionBuilder.create((char)'f');
            OptionBuilder.withLongOpt((String)"fs-input-buffer");
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"size of the file system input buffer (in bytes).");
            Option fsInputBufferSz = OptionBuilder.create((char)'i');
            OptionBuilder.withLongOpt((String)"fs-output-buffer");
            OptionBuilder.withArgName((String)"size");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"size of the file system output buffer (in bytes).");
            Option fsOutputBufferSize = OptionBuilder.create((char)'o');
            OptionBuilder.withLongOpt((String)"key-length");
            OptionBuilder.withArgName((String)"length");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"base length of the key (in bytes), actual length varies in [base, 2*base)");
            Option keyLen = OptionBuilder.create((char)'k');
            OptionBuilder.withLongOpt((String)"value-length");
            OptionBuilder.withArgName((String)"length");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"base length of the value (in bytes), actual length varies in [base, 2*base)");
            Option valueLen = OptionBuilder.create((char)'v');
            OptionBuilder.withLongOpt((String)"word-length");
            OptionBuilder.withArgName((String)"min,max");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"range of dictionary word length (in bytes)");
            Option wordLen = OptionBuilder.create((char)'w');
            OptionBuilder.withLongOpt((String)"block");
            OptionBuilder.withArgName((String)"size-in-KB");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"minimum block size (in KB)");
            Option blockSz = OptionBuilder.create((char)'b');
            OptionBuilder.withLongOpt((String)"seed");
            OptionBuilder.withArgName((String)"long-int");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify the seed");
            Option seed = OptionBuilder.create((char)'S');
            OptionBuilder.withLongOpt((String)"operation");
            OptionBuilder.withArgName((String)"r|w|rw");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"action: read-only, create-only, read-after-create");
            Option operation = OptionBuilder.create((char)'x');
            OptionBuilder.withLongOpt((String)"root-dir");
            OptionBuilder.withArgName((String)"path");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"specify root directory where files will be created.");
            Option rootDir = OptionBuilder.create((char)'r');
            OptionBuilder.withLongOpt((String)"help");
            OptionBuilder.hasArg((boolean)false);
            OptionBuilder.withDescription((String)"show this screen");
            Option help = OptionBuilder.create((String)"h");
            return new Options().addOption(compress).addOption(ditSize).addOption(fileSize).addOption(format).addOption(fsInputBufferSz).addOption(fsOutputBufferSize).addOption(keyLen).addOption(wordLen).addOption(blockSz).addOption(rootDir).addOption(valueLen).addOption(operation).addOption(help);
        }

        private void processOptions(CommandLine line, Options opts) throws ParseException {
            if (line.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                System.out.println("TFile and SeqFile benchmark.");
                System.out.println();
                formatter.printHelp(100, "java ... TestTFileSeqFileComparison [options]", "\nSupported options:", opts, "");
                return;
            }
            if (line.hasOption('c')) {
                this.compress = line.getOptionValue('c');
            }
            if (line.hasOption('d')) {
                this.dictSize = Integer.parseInt(line.getOptionValue('d'));
            }
            if (line.hasOption('s')) {
                this.fileSize = Long.parseLong(line.getOptionValue('s')) * 1024L * 1024L;
            }
            if (line.hasOption('f')) {
                this.format = line.getOptionValue('f');
            }
            if (line.hasOption('i')) {
                this.fsInputBufferSize = Integer.parseInt(line.getOptionValue('i'));
            }
            if (line.hasOption('o')) {
                this.fsOutputBufferSize = Integer.parseInt(line.getOptionValue('o'));
            }
            if (line.hasOption('k')) {
                this.keyLength = Integer.parseInt(line.getOptionValue('k'));
            }
            if (line.hasOption('v')) {
                this.valueLength = Integer.parseInt(line.getOptionValue('v'));
            }
            if (line.hasOption('b')) {
                this.minBlockSize = Integer.parseInt(line.getOptionValue('b')) * 1024;
            }
            if (line.hasOption('r')) {
                this.rootDir = line.getOptionValue('r');
            }
            if (line.hasOption('S')) {
                this.seed = Long.parseLong(line.getOptionValue('S'));
            }
            if (line.hasOption('w')) {
                String min_max = line.getOptionValue('w');
                StringTokenizer st = new StringTokenizer(min_max, " \t,");
                if (st.countTokens() != 2) {
                    throw new ParseException("Bad word length specification: " + min_max);
                }
                this.minWordLen = Integer.parseInt(st.nextToken());
                this.maxWordLen = Integer.parseInt(st.nextToken());
            }
            if (line.hasOption('x')) {
                String strOp = line.getOptionValue('x');
                if (strOp.equals("r")) {
                    this.op = 2;
                } else if (strOp.equals("w")) {
                    this.op = 1;
                } else if (strOp.equals("rw")) {
                    this.op = 3;
                } else {
                    throw new ParseException("Unknown action specifier: " + strOp);
                }
            }
            this.proceed = true;
        }

        private void validateOptions() throws ParseException {
            if (!(this.compress.equals("none") || this.compress.equals("lzo") || this.compress.equals("gz"))) {
                throw new ParseException("Unknown compression scheme: " + this.compress);
            }
            if (!this.format.equals("tfile") && !this.format.equals("seqfile")) {
                throw new ParseException("Unknown file format: " + this.format);
            }
            if (this.minWordLen >= this.maxWordLen) {
                throw new ParseException("Max word length must be greater than min word length.");
            }
        }

        private void setStopProceed() {
            this.proceed = false;
        }

        public boolean doCreate() {
            return (this.op & 1) != 0;
        }

        public boolean doRead() {
            return (this.op & 2) != 0;
        }
    }

    static class SeqFileReadable
    implements KVReadable {
        private SequenceFile.Reader reader;
        private BytesWritable key;
        private BytesWritable value;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int fs,path,osBufferSize \n";

        public SeqFileReadable(FileSystem fs, Path path, int osBufferSize) throws IOException {
            Configuration conf = new Configuration();
            conf.setInt("io.file.buffer.size", osBufferSize);
            this.reader = new SequenceFile.Reader(fs, path, conf);
            this.key = new BytesWritable();
            this.value = new BytesWritable();
        }

        @Override
        public byte[] getKey() {
            return this.key.get();
        }

        @Override
        public int getKeyLength() {
            return this.key.getSize();
        }

        @Override
        public byte[] getValue() {
            return this.value.get();
        }

        @Override
        public int getValueLength() {
            return this.value.getSize();
        }

        @Override
        public boolean next() throws IOException {
            return this.reader.next((Writable)this.key, (Writable)this.value);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    static class SeqFileAppendable
    implements KVAppendable {
        private FSDataOutputStream fsdos;
        private SequenceFile.Writer writer;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int,java.lang.String,int fs,path,osBufferSize,compress,minBlkSize \nappend org.apache.hadoop.io.BytesWritable,org.apache.hadoop.io.BytesWritable key,value \n";

        public SeqFileAppendable(FileSystem fs, Path path, int osBufferSize, String compress, int minBlkSize) throws IOException {
            Configuration conf = new Configuration();
            conf.setBoolean("hadoop.native.lib", true);
            CompressionCodec codec = null;
            if ("lzo".equals(compress)) {
                codec = Compression.Algorithm.LZO.getCodec();
            } else if ("gz".equals(compress)) {
                codec = Compression.Algorithm.GZ.getCodec();
            } else if (!"none".equals(compress)) {
                throw new IOException("Codec not supported.");
            }
            this.fsdos = fs.create(path, true, osBufferSize);
            this.writer = !"none".equals(compress) ? SequenceFile.createWriter((Configuration)conf, (FSDataOutputStream)this.fsdos, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec) : SequenceFile.createWriter((Configuration)conf, (FSDataOutputStream)this.fsdos, BytesWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, null);
        }

        @Override
        public void append(BytesWritable key, BytesWritable value) throws IOException {
            this.writer.append((Writable)key, (Writable)value);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            this.fsdos.close();
        }
    }

    static class TFileReadable
    implements KVReadable {
        private FSDataInputStream fsdis;
        private TFile.Reader reader;
        private TFile.Reader.Scanner scanner;
        private byte[] keyBuffer;
        private int keyLength;
        private byte[] valueBuffer;
        private int valueLength;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,int,org.apache.hadoop.conf.Configuration fs,path,osBufferSize,conf \n";

        public TFileReadable(FileSystem fs, Path path, int osBufferSize, Configuration conf) throws IOException {
            this.fsdis = fs.open(path, osBufferSize);
            this.reader = new TFile.Reader(this.fsdis, fs.getFileStatus(path).getLen(), conf);
            this.scanner = this.reader.createScanner();
            this.keyBuffer = new byte[32];
            this.valueBuffer = new byte[32];
        }

        private void checkKeyBuffer(int size) {
            if (size <= this.keyBuffer.length) {
                return;
            }
            this.keyBuffer = new byte[Math.max(2 * this.keyBuffer.length, 2 * size - this.keyBuffer.length)];
        }

        private void checkValueBuffer(int size) {
            if (size <= this.valueBuffer.length) {
                return;
            }
            this.valueBuffer = new byte[Math.max(2 * this.valueBuffer.length, 2 * size - this.valueBuffer.length)];
        }

        @Override
        public byte[] getKey() {
            return this.keyBuffer;
        }

        @Override
        public int getKeyLength() {
            return this.keyLength;
        }

        @Override
        public byte[] getValue() {
            return this.valueBuffer;
        }

        @Override
        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public boolean next() throws IOException {
            if (this.scanner.atEnd()) {
                return false;
            }
            TFile.Reader.Scanner.Entry entry = this.scanner.entry();
            this.keyLength = entry.getKeyLength();
            this.checkKeyBuffer(this.keyLength);
            entry.getKey(this.keyBuffer);
            this.valueLength = entry.getValueLength();
            this.checkValueBuffer(this.valueLength);
            entry.getValue(this.valueBuffer);
            this.scanner.advance();
            return true;
        }

        @Override
        public void close() throws IOException {
            this.scanner.close();
            this.reader.close();
            this.fsdis.close();
        }
    }

    static class TFileAppendable
    implements KVAppendable {
        private FSDataOutputStream fsdos;
        private TFile.Writer writer;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,java.lang.String,int,int,org.apache.hadoop.conf.Configuration fs,path,compress,minBlkSize,osBufferSize,conf \nappend org.apache.hadoop.io.BytesWritable,org.apache.hadoop.io.BytesWritable key,value \n";

        public TFileAppendable(FileSystem fs, Path path, String compress, int minBlkSize, int osBufferSize, Configuration conf) throws IOException {
            this.fsdos = fs.create(path, true, osBufferSize);
            this.writer = new TFile.Writer(this.fsdos, minBlkSize, compress, null, conf);
        }

        @Override
        public void append(BytesWritable key, BytesWritable value) throws IOException {
            this.writer.append(key.get(), 0, key.getSize(), value.get(), 0, value.getSize());
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
            this.fsdos.close();
        }
    }

    private static interface KVReadable {
        public static final String __PARANAMER_DATA = "";

        public byte[] getKey();

        public byte[] getValue();

        public int getKeyLength();

        public int getValueLength();

        public boolean next() throws IOException;

        public void close() throws IOException;
    }

    private static interface KVAppendable {
        public static final String __PARANAMER_DATA = "append org.apache.hadoop.io.BytesWritable,org.apache.hadoop.io.BytesWritable key,value \n";

        public void append(BytesWritable var1, BytesWritable var2) throws IOException;

        public void close() throws IOException;
    }
}

