/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;

public class RandomDistribution {
    public static final String __PARANAMER_DATA = "";

    public static final class Binomial
    implements DiscreteRNG {
        private final Random random;
        private final int min;
        private final int n;
        private final double[] v;
        public static final String __PARANAMER_DATA = "<init> java.util.Random,int,int,double random,min,max,p \n";

        private static double select(int n, int k) {
            double ret = 1.0;
            for (int i = k + 1; i <= n; ++i) {
                ret *= (double)i / (double)(i - k);
            }
            return ret;
        }

        private static double power(double p, int k) {
            return Math.exp((double)k * Math.log(p));
        }

        public Binomial(Random random, int min, int max, double p) {
            if (min >= max) {
                throw new IllegalArgumentException("Invalid range");
            }
            this.random = random;
            this.min = min;
            this.n = max - min - 1;
            if (this.n > 0) {
                int i;
                this.v = new double[this.n + 1];
                double sum = 0.0;
                for (i = 0; i <= this.n; ++i) {
                    this.v[i] = sum += Binomial.select(this.n, i) * Binomial.power(p, i) * Binomial.power(1.0 - p, this.n - i);
                }
                i = 0;
                while (i <= this.n) {
                    int n = i++;
                    this.v[n] = this.v[n] / sum;
                }
            } else {
                this.v = null;
            }
        }

        @Override
        public int nextInt() {
            if (this.v == null) {
                return this.min;
            }
            double d = this.random.nextDouble();
            int idx = Arrays.binarySearch(this.v, d);
            idx = idx > 0 ? ++idx : -(idx + 1);
            if (idx >= this.v.length) {
                idx = this.v.length - 1;
            }
            return idx + this.min;
        }
    }

    public static final class Zipf
    implements DiscreteRNG {
        private static final double DEFAULT_EPSILON = 0.001;
        private final Random random;
        private final ArrayList<Integer> k;
        private final ArrayList<Double> v;
        public static final String __PARANAMER_DATA = "<init> java.util.Random,int,int,double r,min,max,sigma \n<init> java.util.Random,int,int,double,double r,min,max,sigma,epsilon \n";

        public Zipf(Random r, int min, int max, double sigma) {
            this(r, min, max, sigma, 0.001);
        }

        public Zipf(Random r, int min, int max, double sigma, double epsilon) {
            int i;
            if (max <= min || sigma <= 1.0 || epsilon <= 0.0 || epsilon >= 0.5) {
                throw new IllegalArgumentException("Invalid arguments");
            }
            this.random = r;
            this.k = new ArrayList();
            this.v = new ArrayList();
            double sum = 0.0;
            int last = -1;
            for (i = min; i < max; ++i) {
                sum += Math.exp(-sigma * Math.log(i - min + 1));
                if (last != -1 && !((double)i * (1.0 - epsilon) > (double)last)) continue;
                this.k.add(i);
                this.v.add(sum);
                last = i;
            }
            if (last != max - 1) {
                this.k.add(max - 1);
                this.v.add(sum);
            }
            this.v.set(this.v.size() - 1, 1.0);
            for (i = this.v.size() - 2; i >= 0; --i) {
                this.v.set(i, this.v.get(i) / sum);
            }
        }

        @Override
        public int nextInt() {
            double d = this.random.nextDouble();
            int idx = Collections.binarySearch(this.v, d);
            idx = idx > 0 ? ++idx : -(idx + 1);
            if (idx >= this.v.size()) {
                idx = this.v.size() - 1;
            }
            if (idx == 0) {
                return this.k.get(0);
            }
            int ceiling = this.k.get(idx);
            int lower = this.k.get(idx - 1);
            return ceiling - this.random.nextInt(ceiling - lower);
        }
    }

    public static final class Flat
    implements DiscreteRNG {
        private final Random random;
        private final int min;
        private final int max;
        public static final String __PARANAMER_DATA = "<init> java.util.Random,int,int random,min,max \n";

        public Flat(Random random, int min, int max) {
            if (min >= max) {
                throw new IllegalArgumentException("Invalid range");
            }
            this.random = random;
            this.min = min;
            this.max = max;
        }

        @Override
        public int nextInt() {
            return this.random.nextInt(this.max - this.min) + this.min;
        }
    }

    public static interface DiscreteRNG {
        public static final String __PARANAMER_DATA = "";

        public int nextInt();
    }
}

