/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

public class NanoTimer {
    private long last = -1L;
    private boolean started = false;
    private long cumulate = 0L;
    public static final String __PARANAMER_DATA = "<init> boolean start \nnanoTimeToString long t \nmain java.lang.String[] args \n";

    public NanoTimer(boolean start) {
        if (start) {
            this.start();
        }
    }

    public void start() {
        if (!this.started) {
            this.last = System.nanoTime();
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            this.cumulate += System.nanoTime() - this.last;
        }
    }

    public long read() {
        if (!this.readable()) {
            return -1L;
        }
        return this.cumulate;
    }

    public void reset() {
        this.last = -1L;
        this.started = false;
        this.cumulate = 0L;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        if (!this.readable()) {
            return "ERR";
        }
        return NanoTimer.nanoTimeToString(this.cumulate);
    }

    public static String nanoTimeToString(long t) {
        if (t < 0L) {
            return "ERR";
        }
        if (t == 0L) {
            return "0";
        }
        if (t < 1000L) {
            return t + "ns";
        }
        double us = (double)t / 1000.0;
        if (us < 1000.0) {
            return String.format("%.2fus", us);
        }
        double ms = us / 1000.0;
        if (ms < 1000.0) {
            return String.format("%.2fms", ms);
        }
        double ss = ms / 1000.0;
        if (ss < 1000.0) {
            return String.format("%.2fs", ss);
        }
        long mm = (long)ss / 60L;
        ss -= (double)(mm * 60L);
        long hh = mm / 60L;
        mm -= hh * 60L;
        long dd = hh / 24L;
        hh -= dd * 24L;
        if (dd > 0L) {
            return String.format("%dd%dh", dd, hh);
        }
        if (hh > 0L) {
            return String.format("%dh%dm", hh, mm);
        }
        if (mm > 0L) {
            return String.format("%dm%.1fs", mm, ss);
        }
        return String.format("%.2fs", ss);
    }

    private boolean readable() {
        return this.last != -1L;
    }

    public static void main(String[] args) {
        long i = 7L;
        int x = 0;
        while (x < 20) {
            System.out.println(NanoTimer.nanoTimeToString(i));
            ++x;
            i *= 7L;
        }
    }
}

