/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.file.tfile.RandomDistribution;
import org.apache.hadoop.io.file.tfile.RawComparable;

class KeySampler {
    Random random;
    int min;
    int max;
    RandomDistribution.DiscreteRNG keyLenRNG;
    private static final int MIN_KEY_LEN = 4;
    public static final String __PARANAMER_DATA = "<init> java.util.Random,org.apache.hadoop.io.file.tfile.RawComparable,org.apache.hadoop.io.file.tfile.RawComparable,org.apache.hadoop.io.file.tfile.RandomDistribution.DiscreteRNG random,first,last,keyLenRNG \nnext org.apache.hadoop.io.BytesWritable key \n";

    public KeySampler(Random random, RawComparable first, RawComparable last, RandomDistribution.DiscreteRNG keyLenRNG) throws IOException {
        this.random = random;
        this.min = this.keyPrefixToInt(first);
        this.max = this.keyPrefixToInt(last);
        this.keyLenRNG = keyLenRNG;
    }

    private int keyPrefixToInt(RawComparable key) throws IOException {
        byte[] b = key.buffer();
        int o = key.offset();
        return (b[o] & 0xFF) << 24 | (b[o + 1] & 0xFF) << 16 | (b[o + 2] & 0xFF) << 8 | b[o + 3] & 0xFF;
    }

    public void next(BytesWritable key) {
        key.setSize(Math.max(4, this.keyLenRNG.nextInt()));
        this.random.nextBytes(key.get());
        int n = this.random.nextInt(this.max - this.min) + this.min;
        byte[] b = key.get();
        b[0] = (byte)(n >> 24);
        b[1] = (byte)(n >> 16);
        b[2] = (byte)(n >> 8);
        b[3] = (byte)n;
    }
}

