/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import org.apache.hadoop.io.compress.Decompressor;

class FakeDecompressor
implements Decompressor {
    private boolean finish;
    private boolean finished;
    int nread;
    int nwrite;
    byte[] userBuf;
    int userBufOff;
    int userBufLen;
    public static final String __PARANAMER_DATA = "decompress byte[],int,int b,off,len \nsetDictionary byte[],int,int b,off,len \nsetInput byte[],int,int b,off,len \n";

    FakeDecompressor() {
    }

    public int decompress(byte[] b, int off, int len) throws IOException {
        int n = Math.min(len, this.userBufLen);
        if (this.userBuf != null && b != null) {
            System.arraycopy(this.userBuf, this.userBufOff, b, off, n);
        }
        this.userBufOff += n;
        this.userBufLen -= n;
        this.nwrite += n;
        if (this.finish && this.userBufLen <= 0) {
            this.finished = true;
        }
        return n;
    }

    public void end() {
    }

    public boolean finished() {
        return this.finished;
    }

    public boolean needsDictionary() {
        return false;
    }

    public boolean needsInput() {
        return this.userBufLen <= 0;
    }

    public void reset() {
        this.finish = false;
        this.finished = false;
        this.nread = 0;
        this.nwrite = 0;
        this.userBuf = null;
        this.userBufOff = 0;
        this.userBufLen = 0;
    }

    public void setDictionary(byte[] b, int off, int len) {
    }

    public void setInput(byte[] b, int off, int len) {
        this.nread += len;
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
    }

    public int getRemaining() {
        return 0;
    }
}

