/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableName;

public class TestWritableName
extends TestCase {
    private static final String testName = "mystring";
    public static final String __PARANAMER_DATA = "<init> java.lang.String name \n";

    public TestWritableName(String name) {
        super(name);
    }

    public void testGoodName() throws Exception {
        Configuration conf = new Configuration();
        Class test = WritableName.getClass((String)"long", (Configuration)conf);
        TestWritableName.assertTrue((test != null ? 1 : 0) != 0);
    }

    public void testSetName() throws Exception {
        Configuration conf = new Configuration();
        WritableName.setName(SimpleWritable.class, (String)testName);
        Class test = WritableName.getClass((String)testName, (Configuration)conf);
        TestWritableName.assertTrue((boolean)test.equals(SimpleWritable.class));
    }

    public void testAddName() throws Exception {
        Configuration conf = new Configuration();
        String altName = "mystring.alt";
        WritableName.addName(SimpleWritable.class, (String)altName);
        Class test = WritableName.getClass((String)altName, (Configuration)conf);
        TestWritableName.assertTrue((boolean)test.equals(SimpleWritable.class));
        test = WritableName.getClass((String)testName, (Configuration)conf);
        TestWritableName.assertTrue((boolean)test.equals(SimpleWritable.class));
    }

    public void testBadName() throws Exception {
        Configuration conf = new Configuration();
        try {
            Class test = WritableName.getClass((String)"unknown_junk", (Configuration)conf);
            TestWritableName.assertTrue((boolean)false);
        }
        catch (IOException e) {
            TestWritableName.assertTrue((boolean)e.getMessage().matches(".*unknown_junk.*"));
        }
    }

    public static class SimpleWritable
    implements Writable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \nread java.io.DataInput in \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.state);
        }

        public void readFields(DataInput in) throws IOException {
            this.state = in.readInt();
        }

        public static SimpleWritable read(DataInput in) throws IOException {
            SimpleWritable result = new SimpleWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleWritable)) {
                return false;
            }
            SimpleWritable other = (SimpleWritable)o;
            return this.state == other.state;
        }
    }
}

