/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.TestWritable;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class TestVersionedWritable
extends TestCase {
    public static final String __PARANAMER_DATA = "<init> java.lang.String name \ntestVersionedWritable org.apache.hadoop.io.Writable,org.apache.hadoop.io.Writable before,after \n";

    public TestVersionedWritable(String name) {
        super(name);
    }

    public void testSimpleVersionedWritable() throws Exception {
        TestWritable.testWritable((Writable)new SimpleVersionedWritable());
    }

    public void testAdvancedVersionedWritable() throws Exception {
        TestWritable.testWritable((Writable)new AdvancedVersionedWritable());
    }

    public void testSimpleVersionedWritableMismatch() throws Exception {
        TestVersionedWritable.testVersionedWritable((Writable)new SimpleVersionedWritable(), (Writable)new SimpleVersionedWritableV2());
    }

    public static void testVersionedWritable(Writable before, Writable after) throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        before.write((DataOutput)dob);
        DataInputBuffer dib = new DataInputBuffer();
        dib.reset(dob.getData(), dob.getLength());
        try {
            after.readFields((DataInput)dib);
        }
        catch (VersionMismatchException vmme) {
            System.out.println("Good, we expected this:" + (Object)((Object)vmme));
            return;
        }
        throw new Exception("A Version Mismatch Didn't Happen!");
    }

    public static class SimpleVersionedWritableV2
    extends SimpleVersionedWritable {
        static byte VERSION = (byte)2;
        public static final String __PARANAMER_DATA = "";

        @Override
        public byte getVersion() {
            return VERSION;
        }
    }

    public static class AdvancedVersionedWritable
    extends SimpleVersionedWritable {
        String shortTestString = "Now is the time for all good men to come to the aid of the Party";
        String longTestString = "Four score and twenty years ago. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah.";
        String compressableTestString = "Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. Blah. ";
        SimpleVersionedWritable containedObject = new SimpleVersionedWritable();
        String[] testStringArray = new String[]{"The", "Quick", "Brown", "Fox", "Jumped", "Over", "The", "Lazy", "Dog"};
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        @Override
        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeUTF(this.shortTestString);
            WritableUtils.writeString((DataOutput)out, (String)this.longTestString);
            int comp = WritableUtils.writeCompressedString((DataOutput)out, (String)this.compressableTestString);
            System.out.println("Compression is " + comp + "%");
            this.containedObject.write(out);
            WritableUtils.writeStringArray((DataOutput)out, (String[])this.testStringArray);
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.shortTestString = in.readUTF();
            this.longTestString = WritableUtils.readString((DataInput)in);
            this.compressableTestString = WritableUtils.readCompressedString((DataInput)in);
            this.containedObject.readFields(in);
            this.testStringArray = WritableUtils.readStringArray((DataInput)in);
        }

        @Override
        public boolean equals(Object o) {
            super.equals(o);
            if (!this.shortTestString.equals(((AdvancedVersionedWritable)((Object)o)).shortTestString)) {
                return false;
            }
            if (!this.longTestString.equals(((AdvancedVersionedWritable)((Object)o)).longTestString)) {
                return false;
            }
            if (!this.compressableTestString.equals(((AdvancedVersionedWritable)((Object)o)).compressableTestString)) {
                return false;
            }
            if (this.testStringArray.length != ((AdvancedVersionedWritable)((Object)o)).testStringArray.length) {
                return false;
            }
            for (int i = 0; i < this.testStringArray.length; ++i) {
                if (this.testStringArray[i].equals(((AdvancedVersionedWritable)((Object)o)).testStringArray[i])) continue;
                return false;
            }
            return this.containedObject.equals((Object)((AdvancedVersionedWritable)((Object)o)).containedObject);
        }
    }

    public static class SimpleVersionedWritable
    extends VersionedWritable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();
        private static byte VERSION = 1;
        public static final String __PARANAMER_DATA = "equals java.lang.Object o \nread java.io.DataInput in \nreadFields java.io.DataInput in \nwrite java.io.DataOutput out \n";

        public byte getVersion() {
            return VERSION;
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeInt(this.state);
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.state = in.readInt();
        }

        public static SimpleVersionedWritable read(DataInput in) throws IOException {
            SimpleVersionedWritable result = new SimpleVersionedWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleVersionedWritable)) {
                return false;
            }
            SimpleVersionedWritable other = (SimpleVersionedWritable)((Object)o);
            return this.state == other.state;
        }
    }
}

