/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.SetFile;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class TestSetFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestSetFile.class);
    private static String FILE = System.getProperty("test.build.data", ".") + "/test.set";
    private static Configuration conf = new Configuration();
    public static final String __PARANAMER_DATA = "<init> java.lang.String name \nmain java.lang.String[] args \n";

    public TestSetFile(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFile() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        try {
            RandomDatum[] data = TestSetFile.generate(10000);
            TestSetFile.writeTest((FileSystem)fs, data, FILE, SequenceFile.CompressionType.NONE);
            TestSetFile.readTest((FileSystem)fs, data, FILE);
            TestSetFile.writeTest((FileSystem)fs, data, FILE, SequenceFile.CompressionType.BLOCK);
            TestSetFile.readTest((FileSystem)fs, data, FILE);
        }
        finally {
            fs.close();
        }
    }

    private static RandomDatum[] generate(int count) {
        LOG.info((Object)("generating " + count + " records in memory"));
        Object[] data = new RandomDatum[count];
        RandomDatum.Generator generator = new RandomDatum.Generator();
        for (int i = 0; i < count; ++i) {
            generator.next();
            data[i] = generator.getValue();
        }
        LOG.info((Object)("sorting " + count + " records"));
        Arrays.sort(data);
        return data;
    }

    private static void writeTest(FileSystem fs, RandomDatum[] data, String file, SequenceFile.CompressionType compress) throws IOException {
        MapFile.delete((FileSystem)fs, (String)file);
        LOG.info((Object)("creating with " + data.length + " records"));
        SetFile.Writer writer = new SetFile.Writer(conf, fs, file, WritableComparator.get(RandomDatum.class), compress);
        for (int i = 0; i < data.length; ++i) {
            writer.append((WritableComparable)data[i]);
        }
        writer.close();
    }

    private static void readTest(FileSystem fs, RandomDatum[] data, String file) throws IOException {
        RandomDatum v = new RandomDatum();
        int sample = (int)Math.sqrt(data.length);
        Random random = new Random();
        LOG.info((Object)("reading " + sample + " records"));
        SetFile.Reader reader = new SetFile.Reader(fs, file, conf);
        for (int i = 0; i < sample; ++i) {
            if (reader.seek((WritableComparable)data[random.nextInt(data.length)])) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        LOG.info((Object)("done reading " + data.length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        boolean create = true;
        boolean check = true;
        String file = FILE;
        String compress = "NONE";
        String usage = "Usage: TestSetFile [-count N] [-nocreate] [-nocheck] [-compress type] file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        Path fpath = null;
        FileSystem fs = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-nocheck")) {
                    check = false;
                    continue;
                }
                if (args[i].equals("-compress")) {
                    compress = args[++i];
                    continue;
                }
                file = args[i];
                fpath = new Path(file);
            }
            fs = fpath.getFileSystem(conf);
            LOG.info((Object)("count = " + count));
            LOG.info((Object)("create = " + create));
            LOG.info((Object)("check = " + check));
            LOG.info((Object)("compress = " + compress));
            LOG.info((Object)("file = " + file));
            RandomDatum[] data = TestSetFile.generate(count);
            if (create) {
                TestSetFile.writeTest(fs, data, file, SequenceFile.CompressionType.valueOf((String)compress));
            }
            if (check) {
                TestSetFile.readTest(fs, data, file);
            }
        }
        finally {
            fs.close();
        }
    }
}

