/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.IOUtils;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIOUtils {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testCopyBytesShouldCloseStreamsWhenCloseIsTrue() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldCloseInputSteamWhenOutputStreamCloseThrowsException() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        ((OutputStream)Mockito.doThrow((Throwable)new IOException()).when((Object)outputStream)).close();
        try {
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atLeastOnce())).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atLeastOnce())).close();
    }

    @Test
    public void testCopyBytesShouldNotCloseStreamsWhenCloseIsFalse() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        OutputStream outputStream = (OutputStream)Mockito.mock(OutputStream.class);
        ((InputStream)Mockito.doReturn((Object)-1).when((Object)inputStream)).read(new byte[1]);
        IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)1, (boolean)false);
        ((InputStream)Mockito.verify((Object)inputStream, (VerificationMode)Mockito.atMost((int)0))).close();
        ((OutputStream)Mockito.verify((Object)outputStream, (VerificationMode)Mockito.atMost((int)0))).close();
    }
}

