/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestBooleanWritable {
    public static final String __PARANAMER_DATA = "writeWritable org.apache.hadoop.io.Writable writable \n";

    @Test
    public void testCompareUnequalWritables() throws Exception {
        DataOutputBuffer bTrue = this.writeWritable((Writable)new BooleanWritable(true));
        DataOutputBuffer bFalse = this.writeWritable((Writable)new BooleanWritable(false));
        WritableComparator writableComparator = WritableComparator.get(BooleanWritable.class);
        Assert.assertEquals((long)0L, (long)this.compare(writableComparator, bTrue, bTrue));
        Assert.assertEquals((long)0L, (long)this.compare(writableComparator, bFalse, bFalse));
        Assert.assertEquals((long)1L, (long)this.compare(writableComparator, bTrue, bFalse));
        Assert.assertEquals((long)-1L, (long)this.compare(writableComparator, bFalse, bTrue));
    }

    private int compare(WritableComparator writableComparator, DataOutputBuffer buf1, DataOutputBuffer buf2) {
        return writableComparator.compare(buf1.getData(), 0, buf1.size(), buf2.getData(), 0, buf2.size());
    }

    protected DataOutputBuffer writeWritable(Writable writable) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer(1024);
        writable.write((DataOutput)out);
        out.flush();
        return out;
    }
}

