/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import junit.framework.Assert;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;

public class AvroTestUtil {
    public static final String __PARANAMER_DATA = "testReflect java.lang.Object,java.lang.String value,schema \ntestReflect java.lang.Object,java.lang.reflect.Type,java.lang.String value,type,schema \n";

    public static void testReflect(Object value, String schema) throws Exception {
        AvroTestUtil.testReflect(value, value.getClass(), schema);
    }

    public static void testReflect(Object value, Type type, String schema) throws Exception {
        Schema s = ReflectData.get().getSchema(type);
        Assert.assertEquals((Object)new Schema.Parser().parse(schema), (Object)s);
        ReflectDatumWriter writer = new ReflectDatumWriter(s);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        writer.write(value, (Encoder)encoder);
        encoder.flush();
        ReflectDatumReader reader = new ReflectDatumReader(s);
        Object after = reader.read(null, (Decoder)DecoderFactory.get().binaryDecoder(out.toByteArray(), null));
        Assert.assertEquals((Object)value, (Object)after);
    }
}

