/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.Test;

public class TestHttpServerLifecycle
extends HttpServerFunctionalTest {
    public static final String __PARANAMER_DATA = "";

    private void assertAlive(HttpServer server) {
        TestHttpServerLifecycle.assertTrue((String)"Server is not alive", (boolean)server.isAlive());
        this.assertToStringContains(server, " - alive");
    }

    private void assertNotLive(HttpServer server) {
        TestHttpServerLifecycle.assertTrue((String)"Server should not be live", (!server.isAlive() ? 1 : 0) != 0);
        this.assertToStringContains(server, " - not live");
    }

    @Test
    public void testCreatedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
    }

    @Test
    public void testStopUnstartedServer() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createTestServer();
        TestHttpServerLifecycle.stop(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStartedServerIsAlive() throws Throwable {
        HttpServer server = null;
        try {
            server = TestHttpServerLifecycle.createTestServer();
            this.assertNotLive(server);
            server.start();
            this.assertAlive(server);
        }
        finally {
            TestHttpServerLifecycle.stop(server);
        }
    }

    private void assertToStringContains(HttpServer server, String text) {
        String description = server.toString();
        TestHttpServerLifecycle.assertTrue((String)("Did not find \"" + text + "\" in \"" + description + "\""), (boolean)description.contains(text));
    }

    @Test
    public void testStoppedServerIsNotAlive() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Test
    public void testStoppingTwiceServerIsAllowed() throws Throwable {
        HttpServer server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }
}

