/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.ShellBasedUnixGroupsMapping;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHttpServer
extends HttpServerFunctionalTest {
    private static HttpServer server;
    private static URL baseUrl;
    private static final int MAX_THREADS = 10;
    public static final String __PARANAMER_DATA = "getHttpStatusCode java.lang.String,java.lang.String urlstring,userName \n";

    @BeforeClass
    public static void setup() throws Exception {
        server = TestHttpServer.createTestServer();
        server.addServlet("echo", "/echo", EchoServlet.class);
        server.addServlet("echomap", "/echomap", EchoMapServlet.class);
        server.addServlet("htmlcontent", "/htmlcontent", HtmlContentServlet.class);
        server.start();
        baseUrl = TestHttpServer.getServerURL(server);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        server.stop();
    }

    @Test
    public void testMaxThreads() throws Exception {
        int clientThreads = 100;
        ExecutorService executor = Executors.newFixedThreadPool(clientThreads);
        final CountDownLatch ready = new CountDownLatch(clientThreads);
        final CountDownLatch start = new CountDownLatch(1);
        for (int i = 0; i < clientThreads; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ready.countDown();
                    try {
                        start.await();
                        Assert.assertEquals((Object)"a:b\nc:d\n", (Object)HttpServerFunctionalTest.readOutput(new URL(baseUrl, "/echo?a=b&c=d")));
                        int serverThreads = server.webServer.getThreadPool().getThreads();
                        Assert.assertTrue((serverThreads <= 10 ? 1 : 0) != 0);
                        System.out.println("Number of threads = " + serverThreads + " which is less or equal than the max = " + 10);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        ready.await();
        start.countDown();
    }

    @Test
    public void testEcho() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b\nc&lt;:d\ne:&gt;\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echo?a=b&c<=d&e=>")));
    }

    @Test
    public void testEchoMap() throws Exception {
        TestHttpServer.assertEquals((Object)"a:b\nc:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c=d")));
        TestHttpServer.assertEquals((Object)"a:b,&gt;\nc&lt;:d\n", (Object)TestHttpServer.readOutput(new URL(baseUrl, "/echomap?a=b&c<=d&a=>")));
    }

    @Test
    public void testContentTypes() throws Exception {
        URL cssUrl = new URL(baseUrl, "/static/test.css");
        HttpURLConnection conn = (HttpURLConnection)cssUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/css", (Object)conn.getContentType());
        URL servletUrl = new URL(baseUrl, "/echo?a=b");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/echo?a=b.css");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/plain; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/htmlcontent");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/html; charset=utf-8", (Object)conn.getContentType());
        servletUrl = new URL(baseUrl, "/testjsp.jsp");
        conn = (HttpURLConnection)servletUrl.openConnection();
        conn.connect();
        TestHttpServer.assertEquals((long)200L, (long)conn.getResponseCode());
        TestHttpServer.assertEquals((Object)"text/html; charset=utf-8", (Object)conn.getContentType());
    }

    static int getHttpStatusCode(String urlstring, String userName) throws IOException {
        URL url = new URL(urlstring + "?user.name=" + userName);
        System.out.println("Accessing " + url + " as user " + userName);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        return connection.getResponseCode();
    }

    @Test
    public void testDisabledAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf);
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
        }
        myServer.stop();
    }

    @Test
    public void testAuthorizationOfDefaultServlets() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hadoop.http.filter.initializers", DummyFilterInitializer.class.getName());
        conf.set("hadoop.security.group.mapping", MyGroupsProvider.class.getName());
        Groups.getUserToGroupsMappingService((Configuration)conf);
        MyGroupsProvider.clearMapping();
        MyGroupsProvider.mapping.put("userA", Arrays.asList("groupA"));
        MyGroupsProvider.mapping.put("userB", Arrays.asList("groupB"));
        MyGroupsProvider.mapping.put("userC", Arrays.asList("groupC"));
        MyGroupsProvider.mapping.put("userD", Arrays.asList("groupD"));
        MyGroupsProvider.mapping.put("userE", Arrays.asList("groupE"));
        HttpServer myServer = new HttpServer("test", "0.0.0.0", 0, true, conf, new AccessControlList("userA,userB groupC,groupD"));
        myServer.setAttribute("hadoop.conf", (Object)conf);
        myServer.start();
        int port = myServer.getPort();
        String serverURL = "http://localhost:" + port + "/";
        for (String servlet : new String[]{"conf", "logs", "stacks", "logLevel", "metrics"}) {
            for (String user : new String[]{"userA", "userB", "userC", "userD"}) {
                TestHttpServer.assertEquals((long)200L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, user));
            }
            TestHttpServer.assertEquals((long)401L, (long)TestHttpServer.getHttpStatusCode(serverURL + servlet, "userE"));
        }
        myServer.stop();
    }

    public static class MyGroupsProvider
    extends ShellBasedUnixGroupsMapping {
        static Map<String, List<String>> mapping = new HashMap<String, List<String>>();
        public static final String __PARANAMER_DATA = "getGroups java.lang.String user \n";

        static void clearMapping() {
            mapping.clear();
        }

        public List<String> getGroups(String user) throws IOException {
            return mapping.get(user);
        }
    }

    public static class DummyFilterInitializer
    extends FilterInitializer {
        public static final String __PARANAMER_DATA = "initFilter org.apache.hadoop.http.FilterContainer,org.apache.hadoop.conf.Configuration container,conf \n";

        public void initFilter(FilterContainer container, Configuration conf) {
            container.addFilter("DummyFilter", DummyServletFilter.class.getName(), null);
        }
    }

    public static class DummyServletFilter
    implements Filter {
        private static final Log LOG = LogFactory.getLog(DummyServletFilter.class);
        public static final String __PARANAMER_DATA = "doFilter javax.servlet.ServletRequest,javax.servlet.ServletResponse,javax.servlet.FilterChain request,response,filterChain \ninit javax.servlet.FilterConfig arg0 \n";

        public void destroy() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            final String userName = request.getParameter("user.name");
            HttpServletRequestWrapper requestModified = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return userName;
                }
            };
            filterChain.doFilter((ServletRequest)requestModified, response);
        }

        public void init(FilterConfig arg0) throws ServletException {
        }
    }

    public static class HtmlContentServlet
    extends HttpServlet {
        public static final String __PARANAMER_DATA = "doGet javax.servlet.http.HttpServletRequest,javax.servlet.http.HttpServletResponse request,response \n";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.print("hello world");
            out.close();
        }
    }

    public static class EchoServlet
    extends HttpServlet {
        public static final String __PARANAMER_DATA = "doGet javax.servlet.http.HttpServletRequest,javax.servlet.http.HttpServletResponse request,response \n";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            TreeSet sortedKeys = new TreeSet();
            Enumeration keys = request.getParameterNames();
            while (keys.hasMoreElements()) {
                sortedKeys.add(keys.nextElement());
            }
            for (String key : sortedKeys) {
                out.print(key);
                out.print(':');
                out.print(request.getParameter(key));
                out.print('\n');
            }
            out.close();
        }
    }

    public static class EchoMapServlet
    extends HttpServlet {
        public static final String __PARANAMER_DATA = "doGet javax.servlet.http.HttpServletRequest,javax.servlet.http.HttpServletResponse request,response \n";

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter out = response.getWriter();
            Map params = request.getParameterMap();
            TreeSet keys = new TreeSet(params.keySet());
            for (String key : keys) {
                out.print(key);
                out.print(':');
                String[] values = (String[])params.get(key);
                if (values.length > 0) {
                    out.print(values[0]);
                    for (int i = 1; i < values.length; ++i) {
                        out.print(',');
                        out.print(values[i]);
                    }
                }
                out.print('\n');
            }
            out.close();
        }
    }
}

