/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.http.HtmlQuoting;
import org.junit.Assert;
import org.junit.Test;

public class TestHtmlQuoting {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testNeedsQuoting() throws Exception {
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde>"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"<abcde"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abc'de"));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde\""));
        Assert.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"&"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting((String)__PARANAMER_DATA));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting((String)"ab\ncdef"));
        Assert.assertFalse((boolean)HtmlQuoting.needsQuoting(null));
    }

    @Test
    public void testQuoting() throws Exception {
        Assert.assertEquals((Object)"ab&lt;cd", (Object)HtmlQuoting.quoteHtmlChars((String)"ab<cd"));
        Assert.assertEquals((Object)"ab&gt;", (Object)HtmlQuoting.quoteHtmlChars((String)"ab>"));
        Assert.assertEquals((Object)"&amp;&amp;&amp;", (Object)HtmlQuoting.quoteHtmlChars((String)"&&&"));
        Assert.assertEquals((Object)" &apos;\n", (Object)HtmlQuoting.quoteHtmlChars((String)" '\n"));
        Assert.assertEquals((Object)"&quot;", (Object)HtmlQuoting.quoteHtmlChars((String)"\""));
        Assert.assertEquals(null, (Object)HtmlQuoting.quoteHtmlChars(null));
    }

    private void runRoundTrip(String str) throws Exception {
        Assert.assertEquals((Object)str, (Object)HtmlQuoting.unquoteHtmlChars((String)HtmlQuoting.quoteHtmlChars((String)str)));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.runRoundTrip(__PARANAMER_DATA);
        this.runRoundTrip("<>&'\"");
        this.runRoundTrip("ab>cd<ef&ghi'\"");
        this.runRoundTrip("A string\n with no quotable chars in it!");
        this.runRoundTrip(null);
        StringBuilder buffer = new StringBuilder();
        for (char ch = '\u0000'; ch < '\u007f'; ch = (char)(ch + '\u0001')) {
            buffer.append(ch);
        }
        this.runRoundTrip(buffer.toString());
    }
}

