/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.junit.Assert;

public class HttpServerFunctionalTest
extends Assert {
    public static final String TEST_BUILD_WEBAPPS = "test.build.webapps";
    private static final String BUILD_WEBAPPS_DIR = "build/test/webapps";
    private static final String TEST = "test";
    public static final String __PARANAMER_DATA = "readOutput java.net.URL url \ngetServerURL org.apache.hadoop.http.HttpServer server \ncreateServer java.lang.String webapp \ncreateServer java.lang.String,org.apache.hadoop.conf.Configuration webapp,conf \ncreateTestServer org.apache.hadoop.conf.Configuration conf \nstop org.apache.hadoop.http.HttpServer server \n";

    public static HttpServer createTestServer() throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST);
    }

    public static HttpServer createTestServer(Configuration conf) throws IOException {
        HttpServerFunctionalTest.prepareTestWebapp();
        return HttpServerFunctionalTest.createServer(TEST, conf);
    }

    protected static void prepareTestWebapp() {
        String webapps = System.getProperty(TEST_BUILD_WEBAPPS, BUILD_WEBAPPS_DIR);
        File testWebappDir = new File(webapps + File.separatorChar + TEST);
        if (!testWebappDir.exists()) {
            HttpServerFunctionalTest.fail((String)("Test webapp dir " + testWebappDir + " missing"));
        }
    }

    public static HttpServer createServer(String webapp) throws IOException {
        return new HttpServer(webapp, "0.0.0.0", 0, true);
    }

    public static HttpServer createServer(String webapp, Configuration conf) throws IOException {
        return new HttpServer(webapp, "0.0.0.0", 0, true, conf);
    }

    public static HttpServer createAndStartTestServer() throws IOException {
        HttpServer server = HttpServerFunctionalTest.createTestServer();
        server.start();
        return server;
    }

    public static void stop(HttpServer server) throws Exception {
        if (server != null) {
            server.stop();
        }
    }

    public static URL getServerURL(HttpServer server) throws MalformedURLException {
        HttpServerFunctionalTest.assertNotNull((String)"No server", (Object)server);
        int port = server.getPort();
        return new URL("http://localhost:" + port + "/");
    }

    protected static String readOutput(URL url) throws IOException {
        StringBuilder out = new StringBuilder();
        InputStream in = url.openConnection().getInputStream();
        byte[] buffer = new byte[65536];
        int len = in.read(buffer);
        while (len > 0) {
            out.append(new String(buffer, 0, len));
            len = in.read(buffer);
        }
        return out.toString();
    }
}

