/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.loadGenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.loadGenerator.StructureGenerator;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DataGenerator
extends Configured
implements Tool {
    private File inDir = StructureGenerator.DEFAULT_STRUCTURE_DIRECTORY;
    private Path root = DEFAULT_ROOT;
    private FileSystem fs;
    private static final long BLOCK_SIZE = 10L;
    private static final String USAGE = "java DataGenerator -inDir <inDir> -root <root>";
    static final Path DEFAULT_ROOT = new Path("/testLoadSpace");
    public static final String __PARANAMER_DATA = "run java.lang.String[] args \nmain java.lang.String[] args \n";

    public int run(String[] args) throws Exception {
        int exitCode = 0;
        exitCode = this.init(args);
        if (exitCode != 0) {
            return exitCode;
        }
        this.genDirStructure();
        this.genFiles();
        return exitCode;
    }

    private int init(String[] args) {
        try {
            this.fs = FileSystem.get((Configuration)this.getConf());
        }
        catch (IOException ioe) {
            System.err.println("Can not initialize the file system: " + ioe.getLocalizedMessage());
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-root")) {
                this.root = new Path(args[++i]);
                continue;
            }
            if (args[i].equals("-inDir")) {
                this.inDir = new File(args[++i]);
                continue;
            }
            System.err.println(USAGE);
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            System.exit(-1);
        }
        return 0;
    }

    private void genDirStructure() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(new File(this.inDir, "dirStructure")));
        while ((line = in.readLine()) != null) {
            this.fs.mkdirs(new Path(this.root + line));
        }
    }

    private void genFiles() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(new File(this.inDir, "fileStructure")));
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split(" ");
            if (tokens.length != 2) {
                throw new IOException("Expect at most 2 tokens per line: " + line);
            }
            String fileName = this.root + tokens[0];
            long fileSize = (long)(10.0 * Double.parseDouble(tokens[1]));
            this.genFile(new Path(fileName), fileSize);
        }
    }

    private void genFile(Path file, long fileSize) throws IOException {
        FSDataOutputStream out = this.fs.create(file, true, this.getConf().getInt("io.file.buffer.size", 4096), (short)this.getConf().getInt("dfs.replication", 3), this.fs.getDefaultBlockSize());
        for (long i = 0L; i < fileSize; ++i) {
            out.writeByte(97);
        }
        out.close();
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new DataGenerator(), (String[])args);
        System.exit(res);
    }
}

