/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.Trash;

public class TestTrash
extends TestCase {
    private static final Path TEST_DIR = new Path(new File(System.getProperty("test.build.data", "/tmp")).toURI().toString().replace(' ', '+'), "testTrash");
    public static final String __PARANAMER_DATA = "countSameDeletedFiles org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,org.apache.hadoop.fs.Path fs,trashDir,fileName \nmkdir org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fs,p \nwriteFile org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fs,f \ncheckNotInTrash org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,java.lang.String fs,trashRoot,pathname \ncheckTrash org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path,org.apache.hadoop.fs.Path fs,trashRoot,path \nmain java.lang.String[] arg \ntrashNonDefaultFS org.apache.hadoop.conf.Configuration conf \ntrashShell org.apache.hadoop.fs.FileSystem,org.apache.hadoop.fs.Path fs,base \n";

    protected static Path writeFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream out = fs.create(f);
        out.writeBytes("dhruba: " + f);
        out.close();
        TestTrash.assertTrue((boolean)fs.exists(f));
        return f;
    }

    protected static Path mkdir(FileSystem fs, Path p) throws IOException {
        TestTrash.assertTrue((boolean)fs.mkdirs(p));
        TestTrash.assertTrue((boolean)fs.exists(p));
        TestTrash.assertTrue((boolean)fs.getFileStatus(p).isDirectory());
        return p;
    }

    protected static void checkTrash(FileSystem fs, Path trashRoot, Path path) throws IOException {
        Path p = new Path(trashRoot + "/" + path.toUri().getPath());
        TestTrash.assertTrue((boolean)fs.exists(p));
    }

    protected static int countSameDeletedFiles(FileSystem fs, Path trashDir, Path fileName) throws IOException {
        final String prefix = fileName.getName();
        System.out.println("Counting " + fileName + " in " + trashDir.toString());
        PathFilter pf = new PathFilter(){

            public boolean accept(Path file) {
                return file.getName().startsWith(prefix);
            }
        };
        FileStatus[] fss = fs.listStatus(trashDir, pf);
        return fss == null ? 0 : fss.length;
    }

    static void checkNotInTrash(FileSystem fs, Path trashRoot, String pathname) throws IOException {
        Path p = new Path(trashRoot + "/" + new Path(pathname).getName());
        TestTrash.assertTrue((!fs.exists(p) ? 1 : 0) != 0);
    }

    protected static void trashShell(FileSystem fs, Path base) throws IOException {
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "10");
        conf.set("fs.default.name", fs.getUri().toString());
        FsShell shell = new FsShell();
        shell.setConf(conf);
        Path trashRoot = null;
        Path myPath = new Path(base, "test/mkdirs");
        TestTrash.mkdir(fs, myPath);
        Path myFile = new Path(base, "test/mkdirs/myFile");
        TestTrash.writeFile(fs, myFile);
        String[] args = new String[]{"-expunge"};
        int val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        trashRoot = shell.getCurrentTrashDir();
        TestTrash.checkTrash(fs, trashRoot, myFile);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", new Path(base, "test/mkdirs/myFile").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.mkdir(fs, myPath);
        args = new String[]{"-rmr", new Path(base, "test/mkdirs").toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        Path toErase = new Path(trashRoot, "toErase");
        int retVal = -1;
        TestTrash.writeFile(fs, toErase);
        try {
            retVal = shell.run(new String[]{"-rm", toErase.toString()});
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((retVal == 0 ? 1 : 0) != 0);
        TestTrash.checkNotInTrash(fs, trashRoot, toErase.toString());
        TestTrash.checkNotInTrash(fs, trashRoot, toErase.toString() + ".1");
        args = new String[]{"-expunge"};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkNotInTrash(fs, trashRoot, new Path(base, "test/mkdirs/myFile").toString());
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", myFile.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkTrash(fs, trashRoot, myFile);
        args = new String[]{"-rmr", myPath.toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.checkTrash(fs, trashRoot, myPath);
        args = new String[]{"-rmr", trashRoot.getParent().getParent().toString()};
        val = -1;
        try {
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertTrue((val == -1 ? 1 : 0) != 0);
        TestTrash.assertTrue((boolean)fs.exists(trashRoot));
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rm", "-skipTrash", myFile.toString()};
        val = -1;
        try {
            TestTrash.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertFalse((boolean)fs.exists(trashRoot));
        TestTrash.assertFalse((boolean)fs.exists(myFile));
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        TestTrash.mkdir(fs, myPath);
        TestTrash.writeFile(fs, myFile);
        args = new String[]{"-rmr", "-skipTrash", myPath.toString()};
        val = -1;
        try {
            TestTrash.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
            val = shell.run(args);
        }
        catch (Exception e) {
            System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
        }
        TestTrash.assertFalse((boolean)fs.exists(trashRoot));
        TestTrash.assertFalse((boolean)fs.exists(myPath));
        TestTrash.assertFalse((boolean)fs.exists(myFile));
        TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
        int val2 = -1;
        TestTrash.mkdir(fs, myPath);
        try {
            TestTrash.assertEquals((int)0, (int)shell.run(new String[]{"-expunge"}));
        }
        catch (Exception e) {
            System.err.println("Exception raised from fs expunge " + e.getLocalizedMessage());
        }
        myFile = new Path(base, "test/mkdirs/myFile");
        String[] args2 = new String[]{"-rm", myFile.toString()};
        int num_runs = 10;
        for (int i = 0; i < num_runs; ++i) {
            TestTrash.writeFile(fs, myFile);
            try {
                val2 = shell.run(args2);
            }
            catch (Exception e) {
                System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
            }
            TestTrash.assertTrue((val2 == 0 ? 1 : 0) != 0);
        }
        Path trashDir = new Path(trashRoot.toUri().getPath() + myFile.getParent().toUri().getPath());
        System.out.println("Deleting same myFile: myFile.parent=" + myFile.getParent().toUri().getPath() + "; trashroot=" + trashRoot.toUri().getPath() + "; trashDir=" + trashDir.toUri().getPath());
        int count = TestTrash.countSameDeletedFiles(fs, trashDir, myFile);
        System.out.println("counted " + count + " files " + myFile.getName() + "* in " + trashDir);
        TestTrash.assertTrue((count == num_runs ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trashNonDefaultFS(Configuration conf) throws IOException {
        conf.set("fs.trash.interval", "10");
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)conf);
        Path p = TEST_DIR;
        Path f = new Path(p, "foo/bar");
        if (lfs.exists(p)) {
            lfs.delete(p, true);
        }
        try {
            f = TestTrash.writeFile((FileSystem)lfs, f);
            FileSystem.closeAll();
            FileSystem localFs = FileSystem.get((URI)URI.create("file:///"), (Configuration)conf);
            Trash lTrash = new Trash(localFs, conf);
            lTrash.moveToTrash(f.getParent());
            TestTrash.checkTrash(localFs, lTrash.getCurrentTrashDir(), f);
        }
        finally {
            if (lfs.exists(p)) {
                lfs.delete(p, true);
            }
        }
    }

    public void testTrash() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        TestTrash.trashShell((FileSystem)FileSystem.getLocal((Configuration)conf), TEST_DIR);
    }

    public void testNonDefaultFS() throws IOException {
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.default.name", "invalid://host/bar/foo");
        TestTrash.trashNonDefaultFS(conf);
    }

    public void testTrashEmptier() throws Exception {
        FileStatus[] files;
        Configuration conf = new Configuration();
        conf.set("fs.trash.interval", "0.2");
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        conf.set("fs.trash.checkpoint.interval", "0.1");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.default.name", fs.getUri().toString());
        Trash trash = new Trash(conf);
        Runnable emptier = trash.getEmptier();
        Thread emptierThread = new Thread(emptier);
        emptierThread.start();
        FsShell shell = new FsShell();
        shell.setConf(conf);
        shell.init();
        Path myPath = new Path(TEST_DIR, "test/mkdirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        int fileIndex = 0;
        HashSet<String> checkpoints = new HashSet<String>();
        while (true) {
            Path myFile = new Path(TEST_DIR, "test/mkdirs/myFile" + fileIndex++);
            TestTrash.writeFile((FileSystem)fs, myFile);
            String[] args = new String[]{"-rm", myFile.toString()};
            int val = -1;
            try {
                val = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
            }
            TestTrash.assertTrue((val == 0 ? 1 : 0) != 0);
            Path trashDir = shell.getCurrentTrashDir();
            for (FileStatus file : files = fs.listStatus(trashDir.getParent())) {
                String fileName = file.getPath().getName();
                checkpoints.add(fileName);
            }
            if (checkpoints.size() == 4) break;
            Thread.sleep(5000L);
        }
        TestTrash.assertTrue((checkpoints.size() > files.length ? 1 : 0) != 0);
        emptierThread.interrupt();
        emptierThread.join();
    }

    protected void tearDown() throws IOException {
        File trashDir = new File(TEST_DIR.toUri().getPath());
        if (trashDir.exists() && !FileUtil.fullyDelete((File)trashDir)) {
            throw new IOException("Cannot remove data directory: " + trashDir);
        }
    }

    public static void performanceTestDeleteSameFile() throws IOException {
        Path base = TEST_DIR;
        Configuration conf = new Configuration();
        conf.setClass("fs.file.impl", TestLFS.class, FileSystem.class);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        conf.set("fs.default.name", fs.getUri().toString());
        conf.set("fs.trash.interval", "10");
        FsShell shell = new FsShell();
        shell.setConf(conf);
        Path myPath = new Path(base, "test/mkdirs");
        TestTrash.mkdir((FileSystem)fs, myPath);
        long first = 0L;
        int retVal = 0;
        int factor = 10;
        Path myFile = new Path(base, "test/mkdirs/myFile");
        String[] args = new String[]{"-rm", myFile.toString()};
        int iters = 1000;
        for (int i = 0; i < iters; ++i) {
            long factoredTime;
            TestTrash.writeFile((FileSystem)fs, myFile);
            long start = System.currentTimeMillis();
            try {
                retVal = shell.run(args);
            }
            catch (Exception e) {
                System.err.println("Exception raised from Trash.run " + e.getLocalizedMessage());
                throw new IOException(e.getMessage());
            }
            TestTrash.assertTrue((retVal == 0 ? 1 : 0) != 0);
            long iterTime = System.currentTimeMillis() - start;
            if (i < 10) {
                first = i == 0 ? iterTime : (first + iterTime) / 2L;
            }
            int print_freq = iters / 10;
            if (i <= 10) continue;
            if (i % print_freq == 0) {
                System.out.println("iteration=" + i + ";res =" + retVal + "; start=" + start + "; iterTime = " + iterTime + " vs. firstTime=" + first);
            }
            TestTrash.assertTrue((iterTime < (factoredTime = first * (long)factor) ? 1 : 0) != 0);
        }
    }

    public static void main(String[] arg) throws IOException {
        TestTrash.performanceTestDeleteSameFile();
    }

    static class TestLFS
    extends LocalFileSystem {
        Path home;
        public static final String __PARANAMER_DATA = "<init> org.apache.hadoop.fs.Path home \n";

        TestLFS() {
            this(new Path(TEST_DIR, "user/test"));
        }

        TestLFS(Path home) {
            this.home = home;
        }

        public Path getHomeDirectory() {
            return this.home;
        }
    }
}

