/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.AvroTestUtil;

public class TestPath
extends TestCase {
    public static final String __PARANAMER_DATA = "";

    public void testToString() {
        this.toStringTest("/");
        this.toStringTest("/foo");
        this.toStringTest("/foo/bar");
        this.toStringTest("foo");
        this.toStringTest("foo/bar");
        this.toStringTest("/foo/bar#boo");
        this.toStringTest("foo/bar#boo");
        boolean emptyException = false;
        try {
            this.toStringTest(__PARANAMER_DATA);
        }
        catch (IllegalArgumentException e) {
            emptyException = true;
        }
        TestPath.assertTrue((boolean)emptyException);
        if (Path.WINDOWS) {
            this.toStringTest("c:");
            this.toStringTest("c:/");
            this.toStringTest("c:foo");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:foo/bar");
            this.toStringTest("c:/foo/bar");
            this.toStringTest("C:/foo/bar#boo");
            this.toStringTest("C:foo/bar#boo");
        }
    }

    private void toStringTest(String pathString) {
        TestPath.assertEquals((String)pathString, (String)new Path(pathString).toString());
    }

    public void testNormalize() {
        TestPath.assertEquals((String)__PARANAMER_DATA, (String)new Path(".").toString());
        TestPath.assertEquals((String)"..", (String)new Path("..").toString());
        TestPath.assertEquals((String)"/", (String)new Path("/").toString());
        TestPath.assertEquals((String)"/", (String)new Path("//").toString());
        TestPath.assertEquals((String)"/", (String)new Path("///").toString());
        TestPath.assertEquals((String)"//foo/", (String)new Path("//foo/").toString());
        TestPath.assertEquals((String)"//foo/", (String)new Path("//foo//").toString());
        TestPath.assertEquals((String)"//foo/bar", (String)new Path("//foo//bar").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"/foo", (String)new Path("/foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo/").toString());
        TestPath.assertEquals((String)"foo", (String)new Path("foo//").toString());
        TestPath.assertEquals((String)"foo/bar", (String)new Path("foo//bar").toString());
        if (Path.WINDOWS) {
            TestPath.assertEquals((String)"c:/a/b", (String)new Path("c:\\a\\b").toString());
        }
    }

    public void testIsAbsolute() {
        TestPath.assertTrue((boolean)new Path("/").isAbsolute());
        TestPath.assertTrue((boolean)new Path("/foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo").isAbsolute());
        TestPath.assertFalse((boolean)new Path("foo/bar").isAbsolute());
        TestPath.assertFalse((boolean)new Path(".").isAbsolute());
        if (Path.WINDOWS) {
            TestPath.assertTrue((boolean)new Path("c:/a/b").isAbsolute());
            TestPath.assertFalse((boolean)new Path("c:a/b").isAbsolute());
        }
    }

    public void testParent() {
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path("foo/bar").getParent());
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/foo").getParent());
        TestPath.assertEquals(null, (Object)new Path("/").getParent());
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/"), (Object)new Path("c:/foo").getParent());
        }
    }

    public void testChild() {
        TestPath.assertEquals((Object)new Path("."), (Object)new Path(".", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path("/", "."));
        TestPath.assertEquals((Object)new Path("/"), (Object)new Path(".", "/"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/", "foo"));
        TestPath.assertEquals((Object)new Path("/foo/bar"), (Object)new Path("/foo", "bar"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo/bar/baz"), (Object)new Path("/foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo"), (Object)new Path(".", "foo"));
        TestPath.assertEquals((Object)new Path("foo/bar"), (Object)new Path("foo", "bar"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo", "bar/baz"));
        TestPath.assertEquals((Object)new Path("foo/bar/baz"), (Object)new Path("foo/bar", "baz"));
        TestPath.assertEquals((Object)new Path("/foo"), (Object)new Path("/bar", "/foo"));
        if (Path.WINDOWS) {
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("/bar", "c:/foo"));
            TestPath.assertEquals((Object)new Path("c:/foo"), (Object)new Path("d:/bar", "c:/foo"));
        }
    }

    public void testEquals() {
        TestPath.assertFalse((boolean)new Path("/").equals((Object)new Path("/foo")));
    }

    public void testDots() {
        TestPath.assertEquals((String)new Path("/foo/bar/baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar", ".").toString(), (String)"/foo/bar");
        TestPath.assertEquals((String)new Path("/foo/bar/../baz").toString(), (String)"/foo/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/./baz").toString(), (String)"/foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/../../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz/.././../fud").toString(), (String)"/foo/fud");
        TestPath.assertEquals((String)new Path("../../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path(".././../foo/bar").toString(), (String)"../../foo/bar");
        TestPath.assertEquals((String)new Path("./foo/bar/baz").toString(), (String)"foo/bar/baz");
        TestPath.assertEquals((String)new Path("/foo/bar/../../baz/boo").toString(), (String)"/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/").toString(), (String)"foo/bar");
        TestPath.assertEquals((String)new Path("foo/bar/../baz").toString(), (String)"foo/baz");
        TestPath.assertEquals((String)new Path("foo/bar/../../baz/boo").toString(), (String)"baz/boo");
        TestPath.assertEquals((String)new Path("/foo/bar", "baz/boo").toString(), (String)"/foo/bar/baz/boo");
        TestPath.assertEquals((String)new Path("foo/bar/", "baz/bud").toString(), (String)"foo/bar/baz/bud");
        TestPath.assertEquals((String)new Path("/foo/bar", "../../boo/bud").toString(), (String)"/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar", "../../boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path(".", "boo/bud").toString(), (String)"boo/bud");
        TestPath.assertEquals((String)new Path("/foo/bar/baz", "../../boo/bud").toString(), (String)"/foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../boo/bud").toString(), (String)"foo/boo/bud");
        TestPath.assertEquals((String)new Path("../../", "../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo", "../../../boo/bud").toString(), (String)"../../../../boo/bud");
        TestPath.assertEquals((String)new Path("../../foo/bar", "../boo/bud").toString(), (String)"../../foo/boo/bud");
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../..").toString(), (String)__PARANAMER_DATA);
        TestPath.assertEquals((String)new Path("foo/bar/baz", "../../../../..").toString(), (String)"../..");
    }

    public void testChildParentResolution() throws URISyntaxException, IOException {
        Path parent = new Path("foo1://bar1/baz1");
        Path child = new Path("foo2://bar2/baz2");
        TestPath.assertEquals((Object)child, (Object)new Path(parent, child));
    }

    public void testScheme() throws IOException {
        TestPath.assertEquals((String)"foo:/bar", (String)new Path("foo:/", "/bar").toString());
        TestPath.assertEquals((String)"foo://bar/baz", (String)new Path("foo://bar/", "/baz").toString());
    }

    public void testURI() throws URISyntaxException, IOException {
        URI uri = new URI("file:///bar#baz");
        Path path = new Path(uri);
        TestPath.assertTrue((boolean)uri.equals(new URI(path.toString())));
        FileSystem fs = path.getFileSystem(new Configuration());
        TestPath.assertTrue((boolean)uri.equals(new URI(fs.makeQualified(path).toString())));
        URI uri2 = new URI("file:///bar/baz");
        TestPath.assertTrue((boolean)uri2.equals(new URI(fs.makeQualified(new Path(uri2)).toString())));
        TestPath.assertEquals((String)"foo://bar/baz#boo", (String)new Path("foo://bar/", new Path(new URI("/baz#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/baz/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("fud#boo"))).toString());
        TestPath.assertEquals((String)"foo://bar/fud#boo", (String)new Path(new Path(new URI("foo://bar/baz#bud")), new Path(new URI("/fud#boo"))).toString());
    }

    public void testMakeQualified() throws URISyntaxException {
        URI defaultUri = new URI("hdfs://host1/dir1");
        URI wd = new URI("hdfs://host2/dir2");
        TestPath.assertEquals((Object)new Path("hdfs://host1/dir/file"), (Object)new Path("file").makeQualified(defaultUri, new Path("/dir")));
        TestPath.assertEquals((Object)new Path("hdfs://host2/dir2/file"), (Object)new Path("file").makeQualified(defaultUri, new Path(wd)));
    }

    public void testGetName() {
        TestPath.assertEquals((String)__PARANAMER_DATA, (String)new Path("/").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("foo").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("/foo").getName());
        TestPath.assertEquals((String)"foo", (String)new Path("/foo/").getName());
        TestPath.assertEquals((String)"bar", (String)new Path("/foo/bar").getName());
        TestPath.assertEquals((String)"bar", (String)new Path("hdfs://host/foo/bar").getName());
    }

    public void testAvroReflect() throws Exception {
        AvroTestUtil.testReflect(new Path("foo"), "{\"type\":\"string\",\"java-class\":\"org.apache.hadoop.fs.Path\"}");
    }
}

