/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextSymlinkBaseTest;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLocalFSFileContextSymlink
extends FileContextSymlinkBaseTest {
    public static final String __PARANAMER_DATA = "";

    @Override
    protected String getScheme() {
        return "file";
    }

    @Override
    protected String testBaseDir1() throws IOException {
        return FileContextTestHelper.getAbsoluteTestRootDir(fc) + "/test1";
    }

    @Override
    protected String testBaseDir2() throws IOException {
        return FileContextTestHelper.getAbsoluteTestRootDir(fc) + "/test2";
    }

    @Override
    protected URI testURI() {
        try {
            return new URI("file:///");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        fc = FileContext.getLocalFSFileContext();
        super.setUp();
    }

    @Test
    public void testDanglingLinkFilePartQual() throws IOException {
        Path filePartQual = new Path(this.getScheme() + ":///doesNotExist");
        try {
            fc.getFileLinkStatus(filePartQual);
            Assert.fail((String)"Got FileStatus for non-existant file");
        }
        catch (FileNotFoundException f) {
            // empty catch block
        }
        try {
            fc.getLinkTarget(filePartQual);
            Assert.fail((String)"Got link target for non-existant file");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDanglingLink() throws IOException {
        Path fileAbs = new Path(this.testBaseDir1() + "/file");
        Path fileQual = new Path(this.testURI().toString(), fileAbs);
        Path link = new Path(this.testBaseDir1() + "/linkToFile");
        fc.createSymlink(fileAbs, link, false);
        FileUtil.fullyDelete((File)new File(link.toUri().getPath()));
        fc.createSymlink(fileAbs, link, false);
        try {
            fc.getFileStatus(link);
            Assert.fail((String)"Got FileStatus for dangling link");
        }
        catch (FileNotFoundException f) {
            // empty catch block
        }
        FileStatus fsd = fc.getFileLinkStatus(link);
        Assert.assertEquals((Object)fileQual, (Object)fsd.getSymlink());
        Assert.assertTrue((boolean)fsd.isSymlink());
        Assert.assertFalse((boolean)fsd.isDirectory());
        Assert.assertEquals((Object)__PARANAMER_DATA, (Object)fsd.getOwner());
        Assert.assertEquals((Object)__PARANAMER_DATA, (Object)fsd.getGroup());
        Assert.assertEquals((Object)link, (Object)fsd.getPath());
        Assert.assertEquals((long)0L, (long)fsd.getLen());
        Assert.assertEquals((long)0L, (long)fsd.getBlockSize());
        Assert.assertEquals((long)0L, (long)fsd.getReplication());
        Assert.assertEquals((long)0L, (long)fsd.getAccessTime());
        Assert.assertEquals((Object)FsPermission.getDefault(), (Object)fsd.getPermission());
        try {
            TestLocalFSFileContextSymlink.readFile(link);
            Assert.fail((String)"Got FileStatus for dangling link");
        }
        catch (FileNotFoundException f) {
            // empty catch block
        }
        TestLocalFSFileContextSymlink.createAndWriteFile(fileAbs);
        fc.getFileStatus(link);
    }

    @Test
    public void testGetLinkStatusPartQualTarget() throws IOException {
        Path fileAbs = new Path(this.testBaseDir1() + "/file");
        Path fileQual = new Path(this.testURI().toString(), fileAbs);
        Path dir = new Path(this.testBaseDir1());
        Path link = new Path(this.testBaseDir1() + "/linkToFile");
        Path dirNew = new Path(this.testBaseDir2());
        Path linkNew = new Path(this.testBaseDir2() + "/linkToFile");
        fc.delete(dirNew, true);
        TestLocalFSFileContextSymlink.createAndWriteFile(fileQual);
        fc.setWorkingDirectory(dir);
        fc.createSymlink(fileQual, link, false);
        Assert.assertEquals((Object)fileQual, (Object)fc.getFileLinkStatus(link).getSymlink());
        fc.rename(dir, dirNew, new Options.Rename[0]);
        Assert.assertEquals((Object)fileQual, (Object)fc.getFileLinkStatus(linkNew).getSymlink());
        try {
            TestLocalFSFileContextSymlink.readFile(linkNew);
            Assert.fail((String)"The link should be dangling now.");
        }
        catch (FileNotFoundException x) {
            // empty catch block
        }
        Path anotherFs = new Path("hdfs://host:1000/dir/file");
        FileUtil.fullyDelete((File)new File(linkNew.toString()));
        try {
            fc.createSymlink(anotherFs, linkNew, false);
            Assert.fail((String)"Created a local fs link to a non-local fs");
        }
        catch (IOException x) {
            // empty catch block
        }
    }
}

