/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.fs.GlobPattern;
import org.junit.Assert;
import org.junit.Test;

public class TestGlobPattern {
    public static final String __PARANAMER_DATA = "";

    private void assertMatch(boolean yes, String glob, String ... input) {
        GlobPattern pattern = new GlobPattern(glob);
        for (String s : input) {
            boolean result = pattern.matches((CharSequence)s);
            Assert.assertTrue((String)(glob + " should" + (yes ? __PARANAMER_DATA : " not") + " match " + s), (boolean)(yes ? result : !result));
        }
    }

    private void shouldThrow(String ... globs) {
        for (String glob : globs) {
            try {
                GlobPattern.compile((String)glob);
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                continue;
            }
            Assert.assertTrue((String)("glob " + glob + " should throw"), (boolean)false);
        }
    }

    @Test
    public void testValidPatterns() {
        this.assertMatch(true, "*", "^$", "foo", "bar");
        this.assertMatch(true, "?", "?", "^", "[", "]", "$");
        this.assertMatch(true, "foo*", "foo", "food", "fool");
        this.assertMatch(true, "f*d", "fud", "food");
        this.assertMatch(true, "*d", "good", "bad");
        this.assertMatch(true, "\\*\\?\\[\\{\\\\", "*?[{\\");
        this.assertMatch(true, "[]^-]", "]", "-", "^");
        this.assertMatch(true, "]", "]");
        this.assertMatch(true, "^.$()|+", "^.$()|+");
        this.assertMatch(true, "[^^]", ".", "$", "[", "]");
        this.assertMatch(false, "[^^]", "^");
        this.assertMatch(true, "[!!-]", "^", "?");
        this.assertMatch(false, "[!!-]", "!", "-");
        this.assertMatch(true, "{[12]*,[45]*,[78]*}", "1", "2!", "4", "42", "7", "7$");
        this.assertMatch(false, "{[12]*,[45]*,[78]*}", "3", "6", "9\u00c3\u009f");
        this.assertMatch(true, "}", "}");
    }

    @Test
    public void testInvalidPatterns() {
        this.shouldThrow("[", "[[]]", "[][]", "{", "\\");
    }
}

