/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestFileUtil {
    private static final Log LOG = LogFactory.getLog(TestFileUtil.class);
    private static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "/tmp") + "/fu";
    private static final File TEST_DIR = new File(TEST_ROOT_DIR);
    private static String FILE = "x";
    private static String LINK = "y";
    private static String DIR = "dir";
    private File del = new File(TEST_DIR, "del");
    private File tmp = new File(TEST_DIR, "tmp");
    private File dir1 = new File(this.del, DIR + "1");
    private File dir2 = new File(this.del, DIR + "2");
    private File partitioned = new File(TEST_DIR, "partitioned");
    private File xSubDir = new File(this.del, "xsubdir");
    private File ySubDir = new File(this.del, "ysubdir");
    static String file1Name = "file1";
    private File file2 = new File(this.xSubDir, "file2");
    private File file3 = new File(this.ySubDir, "file3");
    private File zlink = new File(this.del, "zlink");
    public static final String __PARANAMER_DATA = "";

    private void setupDirs() throws IOException {
        Assert.assertFalse((boolean)this.del.exists());
        Assert.assertFalse((boolean)this.tmp.exists());
        Assert.assertFalse((boolean)this.partitioned.exists());
        this.del.mkdirs();
        this.tmp.mkdirs();
        this.partitioned.mkdirs();
        new File(this.del, FILE).createNewFile();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        this.dir1.mkdirs();
        this.dir2.mkdirs();
        new File(this.dir1, FILE).createNewFile();
        new File(this.dir2, FILE).createNewFile();
        File link = new File(this.del, LINK);
        FileUtil.symLink((String)tmpFile.toString(), (String)link.toString());
        File linkDir = new File(this.del, "tmpDir");
        FileUtil.symLink((String)this.tmp.toString(), (String)linkDir.toString());
        Assert.assertEquals((long)5L, (long)this.del.listFiles().length);
        this.createFile(this.partitioned, "part-r-00000", "foo");
        this.createFile(this.partitioned, "part-r-00001", "bar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(File directory, String name, String contents) throws IOException {
        File newFile = new File(directory, name);
        PrintWriter pw = new PrintWriter(newFile);
        try {
            pw.println(contents);
        }
        finally {
            pw.close();
        }
    }

    @After
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)this.del);
        FileUtil.fullyDelete((File)this.tmp);
        FileUtil.fullyDelete((File)this.partitioned);
    }

    @Test
    public void testFullyDelete() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.del.exists());
        this.validateTmpDir();
    }

    @Test
    public void testFullyDeleteSymlinks() throws IOException {
        this.setupDirs();
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        boolean ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)link.exists());
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        this.validateTmpDir();
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)linkDir.exists());
        Assert.assertEquals((long)3L, (long)this.del.list().length);
        this.validateTmpDir();
    }

    @Test
    public void testFullyDeleteDanglingSymlinks() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDelete((File)this.tmp);
        Assert.assertTrue((boolean)ret);
        Assert.assertFalse((boolean)this.tmp.exists());
        File link = new File(this.del, LINK);
        Assert.assertEquals((long)5L, (long)this.del.list().length);
        ret = FileUtil.fullyDelete((File)link);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)4L, (long)this.del.list().length);
        File linkDir = new File(this.del, "tmpDir");
        ret = FileUtil.fullyDelete((File)linkDir);
        Assert.assertTrue((boolean)ret);
        Assert.assertEquals((long)3L, (long)this.del.list().length);
    }

    @Test
    public void testFullyDeleteContents() throws IOException {
        this.setupDirs();
        boolean ret = FileUtil.fullyDeleteContents((File)this.del);
        Assert.assertTrue((boolean)ret);
        Assert.assertTrue((boolean)this.del.exists());
        Assert.assertEquals((long)0L, (long)this.del.listFiles().length);
        this.validateTmpDir();
    }

    private void validateTmpDir() {
        Assert.assertTrue((boolean)this.tmp.exists());
        Assert.assertEquals((long)1L, (long)this.tmp.listFiles().length);
        Assert.assertTrue((boolean)new File(this.tmp, FILE).exists());
    }

    private void setupDirsAndNonWritablePermissions() throws IOException {
        Assert.assertFalse((String)"The directory del should not have existed!", (boolean)this.del.exists());
        this.del.mkdirs();
        new MyFile(this.del, file1Name).createNewFile();
        this.xSubDir.mkdirs();
        this.file2.createNewFile();
        this.xSubDir.setWritable(false);
        this.ySubDir.mkdirs();
        this.file3.createNewFile();
        Assert.assertFalse((String)"The directory tmp should not have existed!", (boolean)this.tmp.exists());
        this.tmp.mkdirs();
        File tmpFile = new File(this.tmp, FILE);
        tmpFile.createNewFile();
        FileUtil.symLink((String)tmpFile.toString(), (String)this.zlink.toString());
    }

    private void validateAndSetWritablePermissions(boolean ret) {
        this.xSubDir.setWritable(true);
        Assert.assertFalse((String)"The return value should have been false!", (boolean)ret);
        Assert.assertTrue((String)"The file file1 should not have been deleted!", (boolean)new File(this.del, file1Name).exists());
        Assert.assertTrue((String)"The directory xsubdir should not have been deleted!", (boolean)this.xSubDir.exists());
        Assert.assertTrue((String)"The file file2 should not have been deleted!", (boolean)this.file2.exists());
        Assert.assertFalse((String)"The directory ysubdir should have been deleted!", (boolean)this.ySubDir.exists());
        Assert.assertFalse((String)"The link zlink should have been deleted!", (boolean)this.zlink.exists());
    }

    @Test
    public void testFailFullyDelete() throws IOException {
        LOG.info((Object)"Running test to verify failure of fullyDelete()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDelete((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(ret);
    }

    @Test
    public void testFailFullyDeleteContents() throws IOException {
        LOG.info((Object)"Running test to verify failure of fullyDeleteContents()");
        this.setupDirsAndNonWritablePermissions();
        boolean ret = FileUtil.fullyDeleteContents((File)new MyFile(this.del));
        this.validateAndSetWritablePermissions(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyMergeSingleDirectory() throws IOException {
        this.setupDirs();
        boolean copyMergeResult = this.copyMerge("partitioned", "tmp/merged");
        Assert.assertTrue((String)"Expected successful copyMerge result.", (boolean)copyMergeResult);
        File merged = new File(TEST_DIR, "tmp/merged");
        Assert.assertTrue((String)"File tmp/merged must exist after copyMerge.", (boolean)merged.exists());
        BufferedReader rdr = new BufferedReader(new FileReader(merged));
        try {
            Assert.assertEquals((String)"Line 1 of merged file must contain \"foo\".", (Object)"foo", (Object)rdr.readLine());
            Assert.assertEquals((String)"Line 2 of merged file must contain \"bar\".", (Object)"bar", (Object)rdr.readLine());
            Assert.assertNull((String)"Expected end of file reading merged file.", (Object)rdr.readLine());
        }
        finally {
            rdr.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyMerge(String src, String dst) throws IOException {
        boolean result;
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        try {
            Path srcPath = new Path(TEST_ROOT_DIR, src);
            Path dstPath = new Path(TEST_ROOT_DIR, dst);
            boolean deleteSource = false;
            String addString = null;
            result = FileUtil.copyMerge((FileSystem)fs, (Path)srcPath, (FileSystem)fs, (Path)dstPath, (boolean)deleteSource, (Configuration)conf, addString);
        }
        finally {
            fs.close();
        }
        return result;
    }

    public static class MyFile
    extends File {
        private static final long serialVersionUID = 1L;
        public static final String __PARANAMER_DATA = "<init> java.io.File f \n<init> java.io.File,java.lang.String parent,child \n";

        public MyFile(File f) {
            super(f.getAbsolutePath());
        }

        public MyFile(File parent, String child) {
            super(parent, child);
        }

        @Override
        public boolean delete() {
            LOG.info((Object)("Trying to delete myFile " + this.getAbsolutePath()));
            boolean bool = false;
            bool = this.getName().equals(file1Name) ? false : super.delete();
            if (bool) {
                LOG.info((Object)("Deleted " + this.getAbsolutePath() + " successfully"));
            } else {
                LOG.info((Object)("Cannot delete " + this.getAbsolutePath()));
            }
            return bool;
        }

        @Override
        public File[] listFiles() {
            File[] files = super.listFiles();
            List<File> filesList = Arrays.asList(files);
            Collections.sort(filesList);
            File[] myFiles = new MyFile[files.length];
            int i = 0;
            for (File f : filesList) {
                myFiles[i++] = new MyFile(f);
            }
            return myFiles;
        }
    }
}

