/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Semaphore;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFileSystemCaching {
    public static final String __PARANAMER_DATA = "";

    @Test
    public void testCacheEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem fs1 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        Assert.assertSame((Object)fs1, (Object)fs2);
    }

    @Test
    public void testCacheEnabledWithInitializeForeverFS() throws Exception {
        final Configuration conf = new Configuration();
        Thread t = new Thread(){

            @Override
            public void run() {
                conf.set("fs.localfs1.impl", "org.apache.hadoop.fs.TestFileSystemCaching$InitializeForeverFileSystem");
                try {
                    FileSystem.get((URI)new URI("localfs1://a"), (Configuration)conf);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        InitializeForeverFileSystem.sem.acquire();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
        t.interrupt();
        t.join();
    }

    @Test
    public void testCacheDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.uncachedfile.impl", conf.get("fs.file.impl"));
        conf.setBoolean("fs.uncachedfile.impl.disable.cache", true);
        FileSystem fs1 = FileSystem.get((URI)new URI("uncachedfile://a"), (Configuration)conf);
        FileSystem fs2 = FileSystem.get((URI)new URI("uncachedfile://a"), (Configuration)conf);
        Assert.assertNotSame((Object)fs1, (Object)fs2);
    }

    @Test
    public <T extends TokenIdentifier> void testCacheForUgi() throws Exception {
        final Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        UserGroupInformation ugiA = UserGroupInformation.createRemoteUser((String)"foo");
        UserGroupInformation ugiB = UserGroupInformation.createRemoteUser((String)"bar");
        FileSystem fsA = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        FileSystem fsA1 = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertSame((Object)fsA, (Object)fsA1);
        FileSystem fsB = (FileSystem)ugiB.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertNotSame((Object)fsA, (Object)fsB);
        Token t1 = (Token)Mockito.mock(Token.class);
        UserGroupInformation ugiA2 = UserGroupInformation.createRemoteUser((String)"foo");
        fsA = (FileSystem)ugiA2.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertNotSame((Object)fsA, (Object)fsA1);
        ugiA.addToken(t1);
        fsA = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertSame((Object)fsA, (Object)fsA1);
    }

    @Test
    public void testUserFS() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem fsU1 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"bar");
        FileSystem fsU2 = FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"foo");
        Assert.assertNotSame((Object)fsU1, (Object)fsU2);
    }

    @Test
    public void testFsUniqueness() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        FileSystem fs1 = FileSystem.get((Configuration)conf);
        FileSystem fs2 = FileSystem.get((Configuration)conf);
        Assert.assertTrue((fs1 == fs2 ? 1 : 0) != 0);
        fs1 = FileSystem.newInstance((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"bar");
        fs2 = FileSystem.newInstance((URI)new URI("cachedfile://a"), (Configuration)conf, (String)"bar");
        Assert.assertTrue((fs1 != fs2 && !fs1.equals(fs2) ? 1 : 0) != 0);
        fs1.close();
        fs2.close();
    }

    @Test
    public void testCloseAllForUGI() throws Exception {
        final Configuration conf = new Configuration();
        conf.set("fs.cachedfile.impl", conf.get("fs.file.impl"));
        UserGroupInformation ugiA = UserGroupInformation.createRemoteUser((String)"foo");
        FileSystem fsA = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        FileSystem fsA1 = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertSame((Object)fsA, (Object)fsA1);
        FileSystem.closeAllForUGI((UserGroupInformation)ugiA);
        fsA1 = (FileSystem)ugiA.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return FileSystem.get((URI)new URI("cachedfile://a"), (Configuration)conf);
            }
        });
        Assert.assertNotSame((Object)fsA, (Object)fsA1);
    }

    public static class InitializeForeverFileSystem
    extends LocalFileSystem {
        static final Semaphore sem = new Semaphore(0);
        public static final String __PARANAMER_DATA = "initialize java.net.URI,org.apache.hadoop.conf.Configuration uri,conf \n";

        public void initialize(URI uri, Configuration conf) throws IOException {
            sem.release();
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

