/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.TestLocalFileSystem;

public class TestChecksumFileSystem
extends TestCase {
    static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data/work-dir/localfs");
    public static final String __PARANAMER_DATA = "";

    public void testgetChecksumLength() throws Exception {
        TestChecksumFileSystem.assertEquals((long)8L, (long)ChecksumFileSystem.getChecksumLength((long)0L, (int)512));
        TestChecksumFileSystem.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)1L, (int)512));
        TestChecksumFileSystem.assertEquals((long)12L, (long)ChecksumFileSystem.getChecksumLength((long)512L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)513L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1023L, (int)512));
        TestChecksumFileSystem.assertEquals((long)16L, (long)ChecksumFileSystem.getChecksumLength((long)1024L, (int)512));
        TestChecksumFileSystem.assertEquals((long)408L, (long)ChecksumFileSystem.getChecksumLength((long)100L, (int)1));
        TestChecksumFileSystem.assertEquals((long)4000000000008L, (long)ChecksumFileSystem.getChecksumLength((long)10000000000000L, (int)10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVerifyChecksum() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path testPath = new Path(TEST_ROOT_DIR, "testPath");
        Path testPath11 = new Path(TEST_ROOT_DIR, "testPath11");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing".getBytes());
        fout.close();
        fout = localFs.create(testPath11);
        fout.write("testing you".getBytes());
        fout.close();
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 128);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 511);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 512);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 513);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1023);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1025);
        localFs.delete(localFs.getChecksumFile(testPath), true);
        TestChecksumFileSystem.assertTrue((String)"checksum deleted", (!localFs.exists(localFs.getChecksumFile(testPath)) ? 1 : 0) != 0);
        FileUtil.copy((FileSystem)localFs, (Path)localFs.getChecksumFile(testPath11), (FileSystem)localFs, (Path)localFs.getChecksumFile(testPath), (boolean)false, (boolean)true, (Configuration)conf);
        TestChecksumFileSystem.assertTrue((String)"checksum exists", (boolean)localFs.exists(localFs.getChecksumFile(testPath)));
        boolean errorRead = false;
        try {
            TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
        }
        catch (ChecksumException ie) {
            errorRead = true;
        }
        TestChecksumFileSystem.assertTrue((String)"error reading", (boolean)errorRead);
        try {
            localFs.setVerifyChecksum(false);
            String str = TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
            TestChecksumFileSystem.assertTrue((String)"read", (boolean)"testing".equals(str));
        }
        finally {
            localFs.setVerifyChecksum(true);
        }
    }

    public void testMultiChunkFile() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path testPath = new Path(TEST_ROOT_DIR, "testMultiChunk");
        FSDataOutputStream fout = localFs.create(testPath);
        for (int i = 0; i < 1000; ++i) {
            fout.write(("testing" + i).getBytes());
        }
        fout.close();
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 128);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 511);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 512);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 513);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1023);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
        TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1025);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTruncatedChecksum() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        Path testPath = new Path(TEST_ROOT_DIR, "testtruncatedcrc");
        FSDataOutputStream fout = localFs.create(testPath);
        fout.write("testing truncation".getBytes());
        fout.close();
        Path checksumFile = localFs.getChecksumFile(testPath);
        FileSystem rawFs = localFs.getRawFileSystem();
        FSDataInputStream checksumStream = rawFs.open(checksumFile);
        byte[] buf = new byte[8192];
        int read = checksumStream.read(buf, 0, buf.length);
        checksumStream.close();
        FSDataOutputStream replaceStream = rawFs.create(checksumFile);
        replaceStream.write(buf, 0, read - 1);
        replaceStream.close();
        try {
            TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
            TestChecksumFileSystem.fail((String)"Did not throw a ChecksumException when reading truncated crc file");
        }
        catch (ChecksumException ie) {
            // empty catch block
        }
        try {
            localFs.setVerifyChecksum(false);
            String str = TestLocalFileSystem.readFile((FileSystem)localFs, testPath, 1024);
            TestChecksumFileSystem.assertTrue((String)"read", (boolean)"testing truncation".equals(str));
        }
        finally {
            localFs.setVerifyChecksum(true);
        }
    }
}

