/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.io.DataOutputBuffer;

public class TestBlockLocation
extends TestCase {
    public static final String __PARANAMER_DATA = "";

    public void testDeserialization() throws IOException {
        String[] names = new String[]{"one", "two"};
        String[] hosts = new String[]{"three", "four"};
        String[] topologyPaths = new String[]{"five", "six"};
        long offset = 25L;
        long length = 55L;
        BlockLocation bl = new BlockLocation(names, hosts, topologyPaths, offset, length);
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            bl.write((DataOutput)dob);
        }
        catch (IOException e) {
            TestBlockLocation.fail((String)("Unable to serialize data: " + e.getMessage()));
        }
        byte[] bytes = dob.getData();
        DataInputStream da = new DataInputStream(new ByteArrayInputStream(bytes));
        BlockLocation bl2 = new BlockLocation();
        try {
            bl2.readFields((DataInput)da);
        }
        catch (IOException e) {
            TestBlockLocation.fail((String)("Unable to deserialize BlockLocation: " + e.getMessage()));
        }
        this.verifyDeserialization(bl2.getHosts(), hosts);
        this.verifyDeserialization(bl2.getNames(), names);
        this.verifyDeserialization(bl2.getTopologyPaths(), topologyPaths);
        TestBlockLocation.assertEquals((long)bl2.getOffset(), (long)offset);
        TestBlockLocation.assertEquals((long)bl2.getLength(), (long)length);
    }

    private void verifyDeserialization(String[] ar1, String[] ar2) {
        TestBlockLocation.assertEquals((int)ar1.length, (int)ar2.length);
        for (int i = 0; i < ar1.length; ++i) {
            TestBlockLocation.assertEquals((String)ar1[i], (String)ar2[i]);
        }
    }
}

